/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.codehaus.plexus.util.IOUtil;

public class RequireFileChecksum
extends AbstractNonCacheableEnforcerRule {
    private File file;
    private String checksum;
    private String type;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        if (this.file == null) {
            throw new EnforcerRuleException("Input file unspecified");
        }
        if (this.type == null) {
            throw new EnforcerRuleException("Hash type unspecified");
        }
        if (this.checksum == null) {
            throw new EnforcerRuleException("Checksum unspecified");
        }
        FileInputStream inputStream = null;
        try {
            String checksum;
            if (this.file.isDirectory() || !this.file.canRead()) {
                throw new EnforcerRuleException("Cannot read file: " + this.file.getAbsolutePath());
            }
            inputStream = new FileInputStream(this.file);
            if ("md5".equals(this.type)) {
                checksum = DigestUtils.md5Hex((InputStream)inputStream);
            } else if ("sha1".equals(this.type)) {
                checksum = DigestUtils.shaHex((InputStream)inputStream);
            } else if ("sha256".equals(this.type)) {
                checksum = DigestUtils.sha256Hex((InputStream)inputStream);
            } else if ("sha384".equals(this.type)) {
                checksum = DigestUtils.sha384Hex((InputStream)inputStream);
            } else if ("sha512".equals(this.type)) {
                checksum = DigestUtils.sha512Hex((InputStream)inputStream);
            } else {
                throw new EnforcerRuleException("Unsupported hash type: " + this.type);
            }
            if (!checksum.equalsIgnoreCase(this.checksum)) {
                throw new EnforcerRuleException(this.type + " hash of " + this.file + " was " + checksum + " but expected " + this.checksum);
            }
        }
        catch (IOException e) {
            try {
                throw new EnforcerRuleException("Unable to calculate checksum", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(inputStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)inputStream);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void setType(String type) {
        this.type = type;
    }
}

