/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugins.enforcer.AbstractVersionEnforcer;

public final class ArtifactMatcher {
    private Collection<Pattern> patterns = new LinkedList<Pattern>();
    private Collection<Pattern> ignorePatterns = new LinkedList<Pattern>();

    public ArtifactMatcher(Collection<String> patterns, Collection<String> ignorePatterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns");
        }
        if (ignorePatterns == null) {
            throw new NullPointerException("ignorePatterns");
        }
        for (String pattern : patterns) {
            if (pattern == null || "".equals(pattern)) continue;
            this.patterns.add(new Pattern(pattern));
        }
        for (String ignorePattern : ignorePatterns) {
            if (ignorePattern == null || "".equals(ignorePattern)) continue;
            this.ignorePatterns.add(new Pattern(ignorePattern));
        }
    }

    public boolean match(Artifact artifact) throws InvalidVersionSpecificationException {
        for (Pattern pattern : this.patterns) {
            if (!pattern.match(artifact)) continue;
            for (Pattern ignorePattern : this.ignorePatterns) {
                if (!ignorePattern.match(artifact)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class Pattern {
        private String pattern;
        private String[] parts;

        public Pattern(String pattern) {
            if (pattern == null) {
                throw new NullPointerException("pattern");
            }
            this.pattern = pattern;
            this.parts = pattern.split(":", 7);
            if (this.parts.length == 7) {
                throw new IllegalArgumentException("Pattern contains too many delimiters.");
            }
            for (String part : this.parts) {
                if (!"".equals(part)) continue;
                throw new IllegalArgumentException("Pattern or its part is empty.");
            }
        }

        public boolean match(Artifact artifact) throws InvalidVersionSpecificationException {
            if (artifact == null) {
                throw new NullPointerException("artifact");
            }
            switch (this.parts.length) {
                case 6: {
                    String classifier = artifact.getClassifier();
                    if (!this.matches(this.parts[5], classifier)) {
                        return false;
                    }
                }
                case 5: {
                    String scope = artifact.getScope();
                    if (scope == null || scope.equals("")) {
                        scope = "compile";
                    }
                    if (!this.matches(this.parts[4], scope)) {
                        return false;
                    }
                }
                case 4: {
                    String type = artifact.getType();
                    if (type == null || type.equals("")) {
                        type = "jar";
                    }
                    if (!this.matches(this.parts[3], type)) {
                        return false;
                    }
                }
                case 3: {
                    if (!this.matches(this.parts[2], artifact.getVersion()) && !AbstractVersionEnforcer.containsVersion(VersionRange.createFromVersionSpec((String)this.parts[2]), (ArtifactVersion)new DefaultArtifactVersion(artifact.getVersion()))) {
                        return false;
                    }
                }
                case 2: {
                    if (!this.matches(this.parts[1], artifact.getArtifactId())) {
                        return false;
                    }
                }
                case 1: {
                    return this.matches(this.parts[0], artifact.getGroupId());
                }
            }
            throw new AssertionError();
        }

        private boolean matches(String expression, String input) {
            String regex = expression.replace(".", "\\.").replace("*", ".*").replace(":", "\\:").replace('?', '.').replace("[", "\\[").replace("]", "\\]").replace("(", "\\(").replace(")", "\\)");
            if (input == null) {
                input = "";
            }
            return java.util.regex.Pattern.matches(regex, input);
        }

        public String toString() {
            return this.pattern;
        }
    }
}

