/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class BanDuplicatePomDependencyVersions
extends AbstractNonCacheableEnforcerRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Model model;
        MavenProject project;
        try {
            project = (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)((Object)eee));
        }
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        try (FileInputStream pomInputStream = new FileInputStream(project.getFile());){
            model = modelReader.read((InputStream)pomInputStream, false);
        }
        catch (IOException | XmlPullParserException e) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)e);
        }
        this.maven2Validation(helper, model);
    }

    private void maven2Validation(EnforcerRuleHelper helper, Model model) throws EnforcerRuleException {
        List dependencies = model.getDependencies();
        Map<String, Integer> duplicateDependencies = this.validateDependencies(dependencies);
        int duplicates = duplicateDependencies.size();
        StringBuilder summary = new StringBuilder();
        this.messageBuilder(duplicateDependencies, "dependencies.dependency", summary);
        if (model.getDependencyManagement() != null) {
            List managementDependencies = model.getDependencyManagement().getDependencies();
            Map<String, Integer> duplicateManagementDependencies = this.validateDependencies(managementDependencies);
            duplicates += duplicateManagementDependencies.size();
            this.messageBuilder(duplicateManagementDependencies, "dependencyManagement.dependencies.dependency", summary);
        }
        List profiles = model.getProfiles();
        for (Profile profile : profiles) {
            List profileDependencies = profile.getDependencies();
            Map<String, Integer> duplicateProfileDependencies = this.validateDependencies(profileDependencies);
            duplicates += duplicateProfileDependencies.size();
            this.messageBuilder(duplicateProfileDependencies, "profiles.profile[" + profile.getId() + "].dependencies.dependency", summary);
            if (profile.getDependencyManagement() == null) continue;
            List profileManagementDependencies = profile.getDependencyManagement().getDependencies();
            Map<String, Integer> duplicateProfileManagementDependencies = this.validateDependencies(profileManagementDependencies);
            duplicates += duplicateProfileManagementDependencies.size();
            this.messageBuilder(duplicateProfileManagementDependencies, "profiles.profile[" + profile.getId() + "].dependencyManagement.dependencies.dependency", summary);
        }
        if (summary.length() > 0) {
            StringBuilder message = new StringBuilder();
            message.append("Found ").append(duplicates).append(" duplicate dependency ");
            message.append(duplicateDependencies.size() == 1 ? "declaration" : "declarations").append(" in this project:" + System.lineSeparator());
            message.append((CharSequence)summary);
            throw new EnforcerRuleException(message.toString());
        }
    }

    private void messageBuilder(Map<String, Integer> duplicateDependencies, String prefix, StringBuilder message) {
        if (!duplicateDependencies.isEmpty()) {
            for (Map.Entry<String, Integer> entry : duplicateDependencies.entrySet()) {
                message.append(" - ").append(prefix).append('[').append(entry.getKey()).append("] ( ").append(entry.getValue()).append(" times )" + System.lineSeparator());
            }
        }
    }

    private Map<String, Integer> validateDependencies(List<Dependency> dependencies) throws EnforcerRuleException {
        HashMap<String, Integer> duplicateDeps = new HashMap<String, Integer>();
        HashSet<String> deps = new HashSet<String>();
        for (Dependency dependency : dependencies) {
            String key = dependency.getManagementKey();
            if (deps.contains(key)) {
                int times = 1;
                if (duplicateDeps.containsKey(key)) {
                    times = (Integer)duplicateDeps.get(key);
                }
                duplicateDeps.put(key, times + 1);
                continue;
            }
            deps.add(key);
        }
        return duplicateDeps;
    }
}

