/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class EnforcerRuleUtils {
    ArtifactResolver resolver;
    ArtifactRepository local;
    List<ArtifactRepository> remoteRepositories;
    Log log;
    MavenProject project;
    private EnforcerRuleHelper helper;

    public EnforcerRuleUtils(ArtifactFactory theFactory, ArtifactResolver theResolver, ArtifactRepository theLocal, List<ArtifactRepository> theRemoteRepositories, MavenProject project, Log theLog) {
        this.resolver = theResolver;
        this.local = theLocal;
        this.remoteRepositories = theRemoteRepositories;
        this.log = theLog;
        this.project = project;
    }

    public EnforcerRuleUtils(EnforcerRuleHelper helper) {
        this.helper = helper;
        try {
            this.resolver = (ArtifactResolver)helper.getComponent(ArtifactResolver.class);
            this.local = (ArtifactRepository)helper.evaluate("${localRepository}");
            this.project = (MavenProject)helper.evaluate("${project}");
            this.remoteRepositories = this.project.getRemoteArtifactRepositories();
        }
        catch (ExpressionEvaluationException | ComponentLookupException e) {
            e.printStackTrace();
        }
    }

    private void resolve(Plugin plugin) {
        try {
            plugin.setGroupId((String)this.helper.evaluate(plugin.getGroupId()));
            plugin.setArtifactId((String)this.helper.evaluate(plugin.getArtifactId()));
            plugin.setVersion((String)this.helper.evaluate(plugin.getVersion()));
        }
        catch (ExpressionEvaluationException expressionEvaluationException) {
            // empty catch block
        }
    }

    private void resolve(ReportPlugin plugin) {
        try {
            plugin.setGroupId((String)this.helper.evaluate(plugin.getGroupId()));
            plugin.setArtifactId((String)this.helper.evaluate(plugin.getArtifactId()));
            plugin.setVersion((String)this.helper.evaluate(plugin.getVersion()));
        }
        catch (ExpressionEvaluationException expressionEvaluationException) {
            // empty catch block
        }
    }

    public List<Plugin> resolvePlugins(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            this.resolve(plugin);
        }
        return plugins;
    }

    public List<ReportPlugin> resolveReportPlugins(List<ReportPlugin> reportPlugins) {
        for (ReportPlugin plugin : reportPlugins) {
            this.resolve(plugin);
        }
        return reportPlugins;
    }
}

