/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;

public class PluginWrapper {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final InputLocationTracker locationTracker;

    public static List<PluginWrapper> addAll(List<? extends InputLocationTracker> plugins, boolean banMavenDefaults) {
        ArrayList<PluginWrapper> results = null;
        if (!plugins.isEmpty()) {
            results = new ArrayList<PluginWrapper>(plugins.size());
            for (InputLocationTracker inputLocationTracker : plugins) {
                if (banMavenDefaults && (PluginWrapper.isVersionFromDefaultLifecycleBindings(inputLocationTracker).orElse(true).booleanValue() || PluginWrapper.isVersionFromSuperpom(inputLocationTracker).orElse(true).booleanValue())) continue;
                if (inputLocationTracker instanceof Plugin) {
                    results.add(new PluginWrapper((Plugin)inputLocationTracker));
                    continue;
                }
                if (!(inputLocationTracker instanceof ReportPlugin)) continue;
                results.add(new PluginWrapper((ReportPlugin)inputLocationTracker));
            }
        }
        return results;
    }

    public static Optional<Boolean> isVersionFromDefaultLifecycleBindings(InputLocationTracker o) {
        InputLocation versionLocation = o.getLocation((Object)"version");
        if (versionLocation == null) {
            return Optional.empty();
        }
        String modelId = versionLocation.getSource().getModelId();
        return Optional.of(modelId.startsWith("org.apache.maven:maven-core:") && modelId.endsWith(":default-lifecycle-bindings"));
    }

    public static Optional<Boolean> isVersionFromSuperpom(InputLocationTracker o) {
        InputLocation versionLocation = o.getLocation((Object)"version");
        if (versionLocation == null) {
            return Optional.empty();
        }
        String modelId = versionLocation.getSource().getModelId();
        return Optional.of(modelId.startsWith("org.apache.maven:maven-model-builder:") && modelId.endsWith(":super-pom"));
    }

    private PluginWrapper(Plugin plugin) {
        this.groupId = plugin.getGroupId();
        this.artifactId = plugin.getArtifactId();
        this.version = plugin.getVersion();
        this.locationTracker = plugin;
    }

    private PluginWrapper(ReportPlugin plugin) {
        this.groupId = plugin.getGroupId();
        this.artifactId = plugin.getArtifactId();
        this.version = plugin.getVersion();
        this.locationTracker = plugin;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSource() {
        InputLocation inputLocation = this.locationTracker.getLocation((Object)"version");
        if (inputLocation == null) {
            return "unknown";
        }
        return inputLocation.getSource().getLocation();
    }
}

