/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.dependency.ResolveUtil;
import org.apache.maven.enforcer.rules.utils.ArtifactMatcher;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

@Named(value="banTransitiveDependencies")
public final class BanTransitiveDependencies
extends AbstractStandardEnforcerRule {
    private List<String> excludes;
    private List<String> includes;
    private final MavenSession session;
    private final ResolveUtil resolveUtil;

    @Inject
    public BanTransitiveDependencies(MavenSession session, ResolveUtil resolveUtil) {
        this.session = Objects.requireNonNull(session);
        this.resolveUtil = Objects.requireNonNull(resolveUtil);
    }

    private static boolean searchTree(DependencyNode node, int level, ArtifactMatcher excludes, Set<Dependency> directDependencies, StringBuilder message) {
        StringBuilder messageFromChildren;
        List children = node.getChildren();
        boolean hasTransitiveDependencies = level > 1;
        boolean excluded = false;
        StringBuilder stringBuilder = messageFromChildren = message == null ? null : new StringBuilder();
        if (excludes.match(ArtifactUtils.toArtifact(node))) {
            excluded = true;
            hasTransitiveDependencies = false;
        } else if (directDependencies.contains(node.getDependency())) {
            hasTransitiveDependencies = false;
        } else {
            for (DependencyNode childNode : children) {
                hasTransitiveDependencies = hasTransitiveDependencies || BanTransitiveDependencies.searchTree(childNode, level + 1, excludes, directDependencies, messageFromChildren);
            }
        }
        if ((excluded || hasTransitiveDependencies) && message != null) {
            message.append(StringUtils.repeat((String)"   ", (int)level)).append(node.getArtifact());
            if (excluded) {
                message.append(" [excluded]").append(System.lineSeparator());
            }
            if (hasTransitiveDependencies) {
                if (level > 0) {
                    message.append(" has transitive dependencies:");
                }
                message.append(System.lineSeparator()).append((CharSequence)messageFromChildren);
            }
        }
        return hasTransitiveDependencies;
    }

    public void execute() throws EnforcerRuleException {
        StringBuilder generatedMessage;
        ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
        ArtifactMatcher exclusions = new ArtifactMatcher(this.excludes, this.includes);
        Set<Dependency> directDependencies = this.session.getCurrentProject().getDependencies().stream().map(d -> RepositoryUtils.toDependency((org.apache.maven.model.Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toSet());
        DependencyNode rootNode = this.resolveUtil.resolveTransitiveDependencies(new DependencySelector[0]);
        if (BanTransitiveDependencies.searchTree(rootNode, 0, exclusions, directDependencies, generatedMessage = new StringBuilder())) {
            throw new EnforcerRuleException(Optional.ofNullable(this.getMessage()).orElse(generatedMessage.toString()));
        }
    }

    public String toString() {
        return String.format("BanTransitiveDependencies[message=%s, excludes=%s]", this.getMessage(), this.excludes);
    }
}

