/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;

@Named
class ResolveUtil {
    private final RepositorySystem repositorySystem;
    private final MavenSession session;

    @Inject
    ResolveUtil(RepositorySystem repositorySystem, MavenSession session) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.session = Objects.requireNonNull(session);
    }

    DependencyNode resolveTransitiveDependencies(DependencySelector ... selectors) throws EnforcerRuleException {
        try {
            MavenProject project = this.session.getCurrentProject();
            ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
            DefaultRepositorySystemSession repositorySystemSession = new DefaultRepositorySystemSession(this.session.getRepositorySession());
            repositorySystemSession.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
            repositorySystemSession.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
            if (selectors.length > 0) {
                repositorySystemSession.setDependencySelector((DependencySelector)new AndDependencySelector(selectors));
            }
            CollectRequest collectRequest = new CollectRequest(project.getDependencies().stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList()), (List)Optional.ofNullable(project.getDependencyManagement()).map(DependencyManagement::getDependencies).map(list -> list.stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList())).orElse(null), project.getRemoteProjectRepositories());
            Artifact artifact = project.getArtifact();
            collectRequest.setRootArtifact(RepositoryUtils.toArtifact((Artifact)artifact));
            return this.repositorySystem.collectDependencies((RepositorySystemSession)repositorySystemSession, collectRequest).getRoot();
        }
        catch (DependencyCollectionException e) {
            throw new EnforcerRuleException("Could not build dependency tree " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }
}

