/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.version;

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.utils.ArtifactMatcher;
import org.codehaus.plexus.util.StringUtils;

abstract class AbstractVersionEnforcer
extends AbstractStandardEnforcerRule {
    private String version;

    AbstractVersionEnforcer() {
    }

    public void enforceVersion(String variableName, String requiredVersionRange, ArtifactVersion actualVersion) throws EnforcerRuleException {
        if (StringUtils.isEmpty((String)requiredVersionRange)) {
            throw new EnforcerRuleException(variableName + " version can't be empty.");
        }
        String msg = "Detected " + variableName + " Version: " + actualVersion;
        if (actualVersion.toString().equals(requiredVersionRange)) {
            this.getLog().debug((CharSequence)(msg + " is allowed in the range " + requiredVersionRange + "."));
        } else {
            try {
                VersionRange vr = VersionRange.createFromVersionSpec((String)requiredVersionRange);
                if (!ArtifactMatcher.containsVersion(vr, actualVersion)) {
                    String message = this.getMessage();
                    if (StringUtils.isEmpty((String)message)) {
                        message = msg + " is not in the allowed range " + AbstractVersionEnforcer.toString(vr) + ".";
                    }
                    throw new EnforcerRuleException(message);
                }
                this.getLog().debug((CharSequence)(msg + " is allowed in the range " + AbstractVersionEnforcer.toString(vr) + "."));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new EnforcerRuleException("The requested " + variableName + " version " + requiredVersionRange + " is invalid.", (Exception)((Object)e));
            }
        }
    }

    protected static String toString(VersionRange vr) {
        if (vr.getRecommendedVersion() != null) {
            return "[" + vr.getRecommendedVersion().toString() + ",)";
        }
        return vr.toString();
    }

    public String getCacheId() {
        if (StringUtils.isNotEmpty((String)this.version)) {
            return "" + this.version.hashCode();
        }
        return "0";
    }

    public final String getVersion() {
        return this.version;
    }

    public void setVersion(String theVersion) {
        this.version = theVersion;
    }
}

