/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRuleConfigProvider;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.utils.ExpressionEvaluator;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named(value="externalRules")
public final class ExternalRules
extends AbstractEnforcerRuleConfigProvider {
    private static final String LOCATION_PREFIX_CLASSPATH = "classpath:";
    private String location;
    private String xsltLocation;
    private final MojoExecution mojoExecution;
    private final ExpressionEvaluator evaluator;

    @Inject
    public ExternalRules(MojoExecution mojoExecution, ExpressionEvaluator evaluator) {
        this.mojoExecution = Objects.requireNonNull(mojoExecution);
        this.evaluator = Objects.requireNonNull(evaluator);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setXsltLocation(String xsltLocation) {
        this.xsltLocation = xsltLocation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Xpp3Dom getRulesConfig() throws EnforcerRuleError {
        try (InputStream descriptorStream = this.transform(this.location, this.resolveDescriptor(this.location), this.xsltLocation);){
            Xpp3Dom enforcerRules = Xpp3DomBuilder.build((InputStream)descriptorStream, (String)"UTF-8");
            if (enforcerRules.getChildCount() != 1) throw new EnforcerRuleError("Enforcer rules configuration not found in: " + this.location);
            if (!"enforcer".equals(enforcerRules.getName())) throw new EnforcerRuleError("Enforcer rules configuration not found in: " + this.location);
            Xpp3Dom xpp3Dom = enforcerRules.getChild(0);
            return xpp3Dom;
        }
        catch (IOException | XmlPullParserException e) {
            throw new EnforcerRuleError(e);
        }
    }

    private InputStream resolveDescriptor(String path) throws EnforcerRuleError {
        InputStream descriptorStream;
        if (path != null) {
            if (path.startsWith(LOCATION_PREFIX_CLASSPATH)) {
                String classpathLocation = path.substring(LOCATION_PREFIX_CLASSPATH.length());
                this.getLog().debug((CharSequence)("Read rules form classpath location: " + classpathLocation));
                ClassRealm classRealm = this.mojoExecution.getMojoDescriptor().getRealm();
                descriptorStream = classRealm.getResourceAsStream(classpathLocation);
                if (descriptorStream == null) {
                    throw new EnforcerRuleError("Location '" + classpathLocation + "' not found in classpath");
                }
            } else {
                File descriptorFile = this.evaluator.alignToBaseDirectory(new File(path));
                this.getLog().debug((CharSequence)("Read rules form file location: " + descriptorFile));
                try {
                    descriptorStream = Files.newInputStream(descriptorFile.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new EnforcerRuleError("Could not read descriptor in " + descriptorFile, (Throwable)e);
                }
            }
        } else {
            throw new EnforcerRuleError("No location provided");
        }
        return descriptorStream;
    }

    public String toString() {
        return String.format("ExternalRules[location=%s, xsltLocation=%s]", this.location, this.xsltLocation);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    InputStream transform(String sourceLocation, InputStream sourceXml, String xsltLocation) {
        if (xsltLocation == null || xsltLocation.trim().isEmpty()) {
            return sourceXml;
        }
        try (InputStream in = this.resolveDescriptor(xsltLocation);){
            ByteArrayInputStream byteArrayInputStream;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(in));
                transformer.transform(new StreamSource(sourceXml), new StreamResult(baos));
                byte[] bytes = baos.toByteArray();
                this.getLog().info(() -> "Rules transformed by " + xsltLocation + " from " + this.location + ":\n\n" + new String(bytes, StandardCharsets.UTF_8));
                byteArrayInputStream = new ByteArrayInputStream(bytes);
            }
            return byteArrayInputStream;
        }
        catch (IOException | TransformerConfigurationException | TransformerFactoryConfigurationError | EnforcerRuleException e) {
            throw new RuntimeException("Could not open resource " + xsltLocation);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Could not transform " + sourceLocation + " usinng XSLT " + xsltLocation);
        }
    }
}

