/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.dependency.BannedDependenciesBase;
import org.apache.maven.enforcer.rules.dependency.ResolverUtil;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.execution.MavenSession;

@Named(value="bannedDependencies")
public final class BannedDependencies
extends BannedDependenciesBase {
    private Predicate<Artifact> shouldExclude;
    private Predicate<Artifact> shouldInclude;

    @Inject
    BannedDependencies(MavenSession session, ResolverUtil resolverUtil) {
        super(session, resolverUtil);
    }

    @Override
    public void execute() throws EnforcerRuleException {
        this.shouldExclude = ArtifactUtils.prepareDependencyArtifactMatcher(this.getExcludes());
        this.shouldInclude = ArtifactUtils.prepareDependencyArtifactMatcher(this.getIncludes());
        super.execute();
    }

    @Override
    protected boolean validate(Artifact artifact) {
        return !this.shouldExclude.test(artifact) || this.shouldInclude.test(artifact);
    }

    @Override
    protected String getErrorMessage() {
        return "banned via the exclude/include list";
    }

    public String toString() {
        return String.format("BannedDependencies[message=%s, excludes=%s, includes=%s, searchTransitive=%b]", this.getMessage(), this.getExcludes(), this.getIncludes(), this.isSearchTransitive());
    }
}

