/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.project.MavenProject;

@Named(value="bannedRepositories")
public final class BannedRepositories
extends AbstractStandardEnforcerRule {
    private List<String> bannedRepositories = Collections.emptyList();
    private List<String> bannedPluginRepositories = Collections.emptyList();
    private List<String> allowedRepositories = Collections.emptyList();
    private List<String> allowedPluginRepositories = Collections.emptyList();
    private final MavenProject project;

    @Inject
    public BannedRepositories(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public void execute() throws EnforcerRuleException {
        List<ArtifactRepository> resultBannedRepos = this.checkRepositories(this.project.getRemoteArtifactRepositories(), this.allowedRepositories, this.bannedRepositories);
        List<ArtifactRepository> resultBannedPluginRepos = this.checkRepositories(this.project.getPluginArtifactRepositories(), this.allowedPluginRepositories, this.bannedPluginRepositories);
        String repoErrMsg = this.populateErrorMessage(resultBannedRepos, " ");
        String pluginRepoErrMsg = this.populateErrorMessage(resultBannedPluginRepos, " plugin ");
        String errMsg = repoErrMsg + pluginRepoErrMsg;
        if (!errMsg.isEmpty()) {
            throw new EnforcerRuleException(errMsg);
        }
    }

    void setBannedRepositories(List<String> bannedRepositories) {
        this.bannedRepositories = bannedRepositories;
    }

    void setAllowedRepositories(List<String> allowedRepositories) {
        this.allowedRepositories = allowedRepositories;
    }

    void setAllowedPluginRepositories(List<String> allowedPluginRepositories) {
        this.allowedPluginRepositories = allowedPluginRepositories;
    }

    private List<ArtifactRepository> checkRepositories(List<ArtifactRepository> repositories, List<String> includes, List<String> excludes) {
        this.getLog().debug(() -> String.format("Check repositories: %s, for includes=%s and excludes=%s", repositories, includes, excludes));
        ArrayList<ArtifactRepository> bannedRepos = new ArrayList<ArtifactRepository>();
        for (ArtifactRepository repo : repositories) {
            String url = repo.getUrl().trim();
            if (includes.size() > 0 && !this.match(url, includes)) {
                bannedRepos.add(repo);
                continue;
            }
            if (excludes.size() <= 0 || !this.match(url, excludes)) continue;
            bannedRepos.add(repo);
        }
        return bannedRepos;
    }

    private boolean match(String url, List<String> patterns) {
        for (String pattern : patterns) {
            if (!this.match(url, pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean match(String text, String pattern) {
        return text.matches(pattern.replace("?", ".?").replace("*", ".*?"));
    }

    private String populateErrorMessage(List<ArtifactRepository> resultBannedRepos, String errorMessagePrefix) {
        if (!resultBannedRepos.isEmpty()) {
            return "Current maven session contains banned" + errorMessagePrefix + "repository urls, please double check your pom or settings.xml:" + System.lineSeparator() + this.getRepositoryUrlString(resultBannedRepos) + System.lineSeparator() + System.lineSeparator();
        }
        return "";
    }

    private String getRepositoryUrlString(List<ArtifactRepository> resultBannedRepos) {
        StringBuilder urls = new StringBuilder();
        for (ArtifactRepository repo : resultBannedRepos) {
            urls.append(repo.getId() + " - " + repo.getUrl() + System.lineSeparator());
        }
        return urls.toString();
    }

    public String toString() {
        return String.format("BannedRepositories[bannedRepositories=%s, bannedPluginRepositories=%s, allowedRepositories=%s, allowedPluginRepositories=%s", this.bannedRepositories, this.bannedPluginRepositories, this.allowedRepositories, this.allowedPluginRepositories);
    }
}

