/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.BuildFailureException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.utils.EnforcerRuleUtils;
import org.apache.maven.enforcer.rules.utils.ExpressionEvaluator;
import org.apache.maven.enforcer.rules.utils.PluginWrapper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Reporting;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.resolution.ArtifactRequest;

@Named(value="requirePluginVersions")
public final class RequirePluginVersions
extends AbstractStandardEnforcerRule {
    private boolean banLatest = true;
    private boolean banRelease = true;
    private boolean banSnapshots = true;
    private boolean banTimestamps = true;
    private boolean banMavenDefaults = true;
    private String phases = "clean,deploy,site";
    private List<String> additionalPlugins;
    private List<String> unCheckedPlugins;
    private String unCheckedPluginList;
    private Map<String, Lifecycle> phaseToLifecycleMap;
    private Collection<Lifecycle> lifecycles;
    private final PluginManager pluginManager;
    private final ArtifactFactory factory;
    private final RepositorySystem repositorySystem;
    private final MavenSession session;
    private final EnforcerRuleUtils utils;
    private final RuntimeInformation runtimeInformation;
    private final DefaultLifecycles defaultLifeCycles;
    private final MavenProject project;
    private final ExpressionEvaluator evaluator;
    private final PlexusContainer container;

    @Inject
    public RequirePluginVersions(PluginManager pluginManager, ArtifactFactory factory, RepositorySystem repositorySystem, MavenSession session, EnforcerRuleUtils utils, RuntimeInformation runtimeInformation, DefaultLifecycles defaultLifeCycles, MavenProject project, ExpressionEvaluator evaluator, PlexusContainer container) {
        this.pluginManager = Objects.requireNonNull(pluginManager);
        this.factory = Objects.requireNonNull(factory);
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.session = Objects.requireNonNull(session);
        this.utils = Objects.requireNonNull(utils);
        this.runtimeInformation = Objects.requireNonNull(runtimeInformation);
        this.defaultLifeCycles = Objects.requireNonNull(defaultLifeCycles);
        this.project = Objects.requireNonNull(project);
        this.evaluator = Objects.requireNonNull(evaluator);
        this.container = Objects.requireNonNull(container);
    }

    public void execute() throws EnforcerRuleException {
        try {
            this.lifecycles = this.defaultLifeCycles.getLifeCycles();
            Set<Plugin> allPlugins = this.getBoundPlugins(this.project, this.phases);
            allPlugins = this.addAdditionalPlugins(allPlugins, this.additionalPlugins);
            allPlugins.addAll(this.getProfilePlugins(this.project));
            allPlugins = this.removeUncheckedPlugins(this.combineUncheckedPlugins(this.unCheckedPlugins, this.unCheckedPluginList), allPlugins);
            if (allPlugins.isEmpty()) {
                this.getLog().info((CharSequence)"No plugin bindings found.");
                return;
            }
            this.getLog().debug((CharSequence)("All Plugins in use: " + allPlugins));
            List<PluginWrapper> pluginWrappers = this.getAllPluginEntries(this.project);
            for (PluginWrapper pluginWrapper : pluginWrappers) {
                this.getLog().debug((CharSequence)("pluginWrappers: " + pluginWrapper.getGroupId() + ":" + pluginWrapper.getArtifactId() + ":" + pluginWrapper.getVersion() + " source: " + pluginWrapper.getSource()));
            }
            ArrayList<Plugin> failures = new ArrayList<Plugin>();
            for (Plugin plugin : allPlugins) {
                if (this.hasValidVersionSpecified(plugin, pluginWrappers)) continue;
                failures.add(plugin);
            }
            if (!failures.isEmpty()) {
                this.handleMessagesToTheUser(this.project, failures);
            }
        }
        catch (LifecycleExecutionException | PluginNotFoundException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage(), (Exception)e);
        }
    }

    private void handleMessagesToTheUser(MavenProject project, List<Plugin> failures) throws EnforcerRuleException {
        StringBuilder newMsg = new StringBuilder();
        newMsg.append("Some plugins are missing valid versions or depend on Maven ");
        newMsg.append(this.runtimeInformation.getMavenVersion());
        newMsg.append(" defaults");
        this.handleBanMessages(newMsg);
        newMsg.append(System.lineSeparator());
        for (Plugin plugin : failures) {
            newMsg.append("   ");
            newMsg.append(plugin.getGroupId());
            newMsg.append(":");
            newMsg.append(plugin.getArtifactId());
            try {
                newMsg.append(". \tThe version currently in use is ");
                Plugin currentPlugin = this.findCurrentPlugin(plugin, project);
                if (currentPlugin == null) {
                    newMsg.append("unknown");
                } else {
                    newMsg.append(currentPlugin.getVersion());
                    if (PluginWrapper.isVersionFromDefaultLifecycleBindings((InputLocationTracker)currentPlugin).orElse(false).booleanValue()) {
                        newMsg.append(" via default lifecycle bindings");
                    } else {
                        String msg = PluginWrapper.isVersionFromSuperpom((InputLocationTracker)currentPlugin).filter(b -> b).map(t -> " via super POM").orElse(" via super POM or default lifecycle bindings");
                        newMsg.append(msg);
                    }
                }
            }
            catch (Exception e) {
                this.getLog().debug((CharSequence)("Exception while determining plugin Version " + e.getMessage()));
                newMsg.append(". Unable to determine the plugin version.");
            }
            newMsg.append(System.lineSeparator());
        }
        String message = this.getMessage();
        if (message != null && !message.isEmpty()) {
            newMsg.append(message);
        }
        throw new EnforcerRuleException(newMsg.toString());
    }

    private void handleBanMessages(StringBuilder newMsg) {
        if (this.banLatest || this.banRelease || this.banSnapshots || this.banTimestamps) {
            ArrayList<String> banList = new ArrayList<String>();
            if (this.banLatest) {
                banList.add("LATEST");
            }
            if (this.banRelease) {
                banList.add("RELEASE");
            }
            if (this.banSnapshots) {
                banList.add("SNAPSHOT");
                if (this.banTimestamps) {
                    banList.add("TIMESTAMP SNAPSHOT");
                }
            }
            if (!banList.isEmpty()) {
                newMsg.append(" (");
                newMsg.append(String.join((CharSequence)", ", banList));
                newMsg.append(" as plugin version are not allowed)");
            }
        }
    }

    Set<Plugin> removeUncheckedPlugins(Collection<String> uncheckedPlugins, Set<Plugin> plugins) throws EnforcerRuleError {
        if (uncheckedPlugins != null && !uncheckedPlugins.isEmpty()) {
            for (String pluginKey : uncheckedPlugins) {
                Plugin plugin = this.parsePluginString(pluginKey, "UncheckedPlugins");
                plugins.remove(plugin);
            }
        }
        return plugins;
    }

    public Collection<String> combineUncheckedPlugins(Collection<String> uncheckedPlugins, String uncheckedPluginsList) {
        if (uncheckedPluginsList != null && !uncheckedPluginsList.isEmpty()) {
            if (uncheckedPlugins == null) {
                uncheckedPlugins = new HashSet<String>();
            } else if (!uncheckedPlugins.isEmpty()) {
                this.getLog().warn((CharSequence)"The parameter 'unCheckedPlugins' is deprecated. Use 'unCheckedPluginList' instead");
            }
            uncheckedPlugins.addAll(Arrays.asList(uncheckedPluginsList.split(",")));
        }
        return uncheckedPlugins;
    }

    public Set<Plugin> addAdditionalPlugins(Set<Plugin> existing, List<String> additional) throws EnforcerRuleError {
        if (additional != null) {
            if (existing == null) {
                existing = new HashSet<Plugin>();
            }
            for (String pluginString : additional) {
                Plugin plugin = this.parsePluginString(pluginString, "AdditionalPlugins");
                existing.add(plugin);
            }
        }
        return existing;
    }

    private Plugin parsePluginString(String pluginString, String field) throws EnforcerRuleError {
        if (pluginString != null) {
            String[] pluginStrings = pluginString.split(":");
            if (pluginStrings.length == 2) {
                Plugin plugin = new Plugin();
                plugin.setGroupId(StringUtils.strip((String)pluginStrings[0]));
                plugin.setArtifactId(StringUtils.strip((String)pluginStrings[1]));
                return plugin;
            }
            throw new EnforcerRuleError("Invalid " + field + " string: " + pluginString);
        }
        throw new EnforcerRuleError("Invalid " + field + " null plugin string.");
    }

    public Set<Plugin> getProfilePlugins(MavenProject project) {
        HashSet<Plugin> result = new HashSet<Plugin>();
        List profiles = project.getActiveProfiles();
        if (profiles != null && !profiles.isEmpty()) {
            for (Profile p : profiles) {
                List plugins;
                BuildBase b = p.getBuild();
                if (b == null || (plugins = b.getPlugins()) == null) continue;
                result.addAll(plugins);
            }
        }
        return result;
    }

    private Plugin findCurrentPlugin(Plugin plugin, MavenProject project) throws EnforcerRuleException {
        Plugin found = null;
        try {
            Model model = project.getModel();
            Map plugins = model.getBuild().getPluginsAsMap();
            found = (Plugin)plugins.get(plugin.getKey());
        }
        catch (NullPointerException model) {
            // empty catch block
        }
        if (found == null) {
            Artifact artifact = this.factory.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), VersionRange.createFromVersion((String)"LATEST"));
            try {
                this.repositorySystem.resolveArtifact(this.session.getRepositorySession(), new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), this.session.getCurrentProject().getRemotePluginRepositories(), "resolvePlugin"));
            }
            catch (org.eclipse.aether.resolution.ArtifactResolutionException e) {
                throw new EnforcerRuleException("Unable to resolve the plugin " + artifact.getArtifactId(), (Exception)((Object)e));
            }
            plugin.setVersion(artifact.getVersion());
            found = plugin;
        }
        return found;
    }

    private Set<Plugin> getBoundPlugins(MavenProject project, String phases) throws PluginNotFoundException, LifecycleExecutionException {
        HashSet<Plugin> allPlugins = new HashSet<Plugin>();
        String[] lifecyclePhases = phases.split(",");
        for (int i = 0; i < lifecyclePhases.length; ++i) {
            String lifecyclePhase = lifecyclePhases[i];
            if (lifecyclePhase == null || lifecyclePhase.isEmpty()) continue;
            try {
                Lifecycle lifecycle = this.getLifecycleForPhase(lifecyclePhase);
                this.getLog().debug((CharSequence)("getBoundPlugins(): " + project.getId() + " " + lifecyclePhase + " " + lifecycle.getId()));
                allPlugins.addAll(this.getAllPlugins(project, lifecycle));
                continue;
            }
            catch (BuildFailureException buildFailureException) {
                // empty catch block
            }
        }
        return allPlugins;
    }

    public boolean hasValidVersionSpecified(Plugin source, List<PluginWrapper> pluginWrappers) {
        boolean found = false;
        boolean status = false;
        for (PluginWrapper plugin : pluginWrappers) {
            if (!this.isMatchingPlugin(source, plugin)) continue;
            found = true;
            String version = plugin.getVersion();
            try {
                version = (String)this.evaluator.evaluate(version);
            }
            catch (ExpressionEvaluationException e) {
                return false;
            }
            if (!this.isValidVersion(version)) continue;
            this.getLog().debug((CharSequence)("checking for notEmpty and notIsWhitespace(): " + version));
            if (this.banRelease && version.equals("RELEASE")) {
                return false;
            }
            if (this.banLatest && version.equals("LATEST")) {
                return false;
            }
            if (this.banSnapshots && this.isSnapshot(version)) {
                return false;
            }
            status = true;
            if (this.banRelease || this.banLatest || this.banSnapshots) continue;
            break;
        }
        if (!found) {
            this.getLog().debug((CharSequence)("plugin " + source.getGroupId() + ":" + source.getArtifactId() + " not found"));
        }
        return status;
    }

    private boolean isValidVersion(String version) {
        return version != null && !version.isEmpty() && !StringUtils.isWhitespace((String)version);
    }

    private boolean isMatchingPlugin(Plugin source, PluginWrapper plugin) {
        return source.getArtifactId().equals(plugin.getArtifactId()) && source.getGroupId().equals(plugin.getGroupId());
    }

    private boolean isSnapshot(String baseVersion) {
        if (this.banTimestamps) {
            return Artifact.VERSION_FILE_PATTERN.matcher(baseVersion).matches() || baseVersion.endsWith("SNAPSHOT");
        }
        return baseVersion.endsWith("SNAPSHOT");
    }

    private Set<Plugin> getAllPlugins(MavenProject project, Lifecycle lifecycle) throws PluginNotFoundException, LifecycleExecutionException {
        this.getLog().debug((CharSequence)"RequirePluginVersions.getAllPlugins:");
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        Map<String, String> mappings = this.findMappingsForLifecycle(project, lifecycle);
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String[] pluginList;
            this.getLog().debug((CharSequence)("  lifecycleMapping = " + entry.getKey()));
            String pluginsForLifecycle = entry.getValue();
            this.getLog().debug((CharSequence)("  plugins = " + pluginsForLifecycle));
            if (pluginsForLifecycle == null || pluginsForLifecycle.isEmpty()) continue;
            for (String plugin : pluginList = pluginsForLifecycle.split(",")) {
                plugin = StringUtils.strip((String)plugin);
                this.getLog().debug((CharSequence)("    plugin = " + plugin));
                String[] tokens = plugin.split(":");
                this.getLog().debug((CharSequence)("    GAV = " + Arrays.asList(tokens)));
                Plugin p = new Plugin();
                p.setGroupId(tokens[0]);
                p.setArtifactId(tokens[1]);
                plugins.add(p);
            }
        }
        plugins.addAll(project.getBuildPlugins());
        return plugins;
    }

    public Map<String, Lifecycle> getPhaseToLifecycleMap() throws LifecycleExecutionException {
        if (this.phaseToLifecycleMap == null) {
            this.phaseToLifecycleMap = new HashMap<String, Lifecycle>();
            for (Lifecycle lifecycle : this.lifecycles) {
                List phases = lifecycle.getPhases();
                for (String phase : phases) {
                    this.getLog().debug((CharSequence)("getPhaseToLifecycleMap(): phase: " + phase));
                    if (this.phaseToLifecycleMap.containsKey(phase)) {
                        Lifecycle prevLifecycle = this.phaseToLifecycleMap.get(phase);
                        throw new LifecycleExecutionException("Phase '" + phase + "' is defined in more than one lifecycle: '" + lifecycle.getId() + "' and '" + prevLifecycle.getId() + "'");
                    }
                    this.phaseToLifecycleMap.put(phase, lifecycle);
                }
            }
        }
        return this.phaseToLifecycleMap;
    }

    private Lifecycle getLifecycleForPhase(String phase) throws BuildFailureException, LifecycleExecutionException {
        Lifecycle lifecycle = this.getPhaseToLifecycleMap().get(phase);
        if (lifecycle == null) {
            throw new BuildFailureException("Unable to find lifecycle for phase '" + phase + "'");
        }
        return lifecycle;
    }

    private Map<String, String> findMappingsForLifecycle(MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        Map defaultMappings;
        Map mappings;
        String packaging;
        block6: {
            packaging = project.getPackaging();
            mappings = null;
            LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, this.session.getSettings(), this.session.getLocalRepository());
            if (m != null) {
                mappings = m.getPhases(lifecycle.getId());
            }
            defaultMappings = lifecycle.getDefaultPhases();
            if (mappings == null) {
                try {
                    m = (LifecycleMapping)this.container.lookup(LifecycleMapping.class, packaging);
                    mappings = m.getPhases(lifecycle.getId());
                }
                catch (ComponentLookupException e) {
                    if (defaultMappings != null) break block6;
                    throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "'.", (Throwable)e);
                }
            }
        }
        if (mappings == null) {
            if (defaultMappings == null) {
                throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "', and there is no default");
            }
            mappings = defaultMappings;
        }
        return mappings;
    }

    private Object findExtension(MavenProject project, String role, String roleHint, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        Object pluginComponent = null;
        List buildPlugins = project.getBuildPlugins();
        for (Plugin plugin : buildPlugins) {
            if (!plugin.isExtensions()) continue;
            this.verifyPlugin(plugin, project, settings, localRepository);
            try {
                pluginComponent = this.pluginManager.getPluginComponent(plugin, role, roleHint);
                if (pluginComponent == null) continue;
                break;
            }
            catch (ComponentLookupException e) {
                this.getLog().debug((CharSequence)("Unable to find the lifecycle component in the extension " + e.getMessage()));
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException("Error getting extensions from the plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return pluginComponent;
    }

    private void verifyPlugin(Plugin plugin, MavenProject project, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        try {
            this.pluginManager.verifyPlugin(plugin, project, settings, localRepository);
        }
        catch (PluginManagerException e) {
            throw new LifecycleExecutionException("Internal error in the plugin manager getting plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException | InvalidVersionSpecificationException | InvalidPluginException | PluginVersionNotFoundException | PluginVersionResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
    }

    private List<PluginWrapper> getAllPluginEntries(MavenProject project) {
        ArrayList<PluginWrapper> plugins = new ArrayList<PluginWrapper>();
        this.getPlugins(plugins, project.getModel());
        this.getReportingPlugins(plugins, project.getModel());
        this.getPluginManagementPlugins(plugins, project.getModel());
        this.addPluginsInProfiles(plugins, project.getModel());
        return plugins;
    }

    private void addPluginsInProfiles(List<PluginWrapper> plugins, Model model) {
        List profiles = Optional.ofNullable(model).map(Model::getProfiles).orElseGet(Collections::emptyList);
        for (Profile profile : profiles) {
            this.getProfilePlugins(plugins, profile);
            this.getProfileReportingPlugins(plugins, profile);
            this.getProfilePluginManagementPlugins(plugins, profile);
        }
    }

    private void getProfilePluginManagementPlugins(List<PluginWrapper> plugins, Profile profile) {
        List modelPlugins = Optional.ofNullable(profile).map(Profile::getBuild).map(PluginConfiguration::getPluginManagement).map(PluginContainer::getPlugins).orElseGet(Collections::emptyList);
        plugins.addAll(PluginWrapper.addAll(this.utils.resolvePlugins(modelPlugins), this.banMavenDefaults));
    }

    private void getProfileReportingPlugins(List<PluginWrapper> plugins, Profile profile) {
        List modelReportPlugins = Optional.ofNullable(profile).map(ModelBase::getReporting).map(Reporting::getPlugins).orElseGet(Collections::emptyList);
        plugins.addAll(PluginWrapper.addAll(this.utils.resolveReportPlugins(modelReportPlugins), this.banMavenDefaults));
    }

    private void getProfilePlugins(List<PluginWrapper> plugins, Profile profile) {
        List modelPlugins = Optional.ofNullable(profile).map(Profile::getBuild).map(PluginContainer::getPlugins).orElseGet(Collections::emptyList);
        plugins.addAll(PluginWrapper.addAll(this.utils.resolvePlugins(modelPlugins), this.banMavenDefaults));
    }

    private void getPlugins(List<PluginWrapper> plugins, Model model) {
        List modelPlugins = Optional.ofNullable(model).map(Model::getBuild).map(PluginContainer::getPlugins).orElseGet(Collections::emptyList);
        plugins.addAll(PluginWrapper.addAll(this.utils.resolvePlugins(modelPlugins), this.banMavenDefaults));
    }

    private void getPluginManagementPlugins(List<PluginWrapper> plugins, Model model) {
        List modelPlugins = Optional.ofNullable(model).map(Model::getBuild).map(PluginConfiguration::getPluginManagement).map(PluginContainer::getPlugins).orElseGet(Collections::emptyList);
        plugins.addAll(PluginWrapper.addAll(this.utils.resolvePlugins(modelPlugins), this.banMavenDefaults));
    }

    private void getReportingPlugins(List<PluginWrapper> plugins, Model model) {
        List modelReportPlugins = Optional.ofNullable(model).map(ModelBase::getReporting).map(Reporting::getPlugins).orElseGet(Collections::emptyList);
        plugins.addAll(PluginWrapper.addAll(this.utils.resolveReportPlugins(modelReportPlugins), this.banMavenDefaults));
    }

    public void setBanLatest(boolean banLatest) {
        this.banLatest = banLatest;
    }

    public void setBanRelease(boolean banRelease) {
        this.banRelease = banRelease;
    }

    public boolean isBanSnapshots() {
        return this.banSnapshots;
    }

    public void setBanSnapshots(boolean banSnapshots) {
        this.banSnapshots = banSnapshots;
    }

    public void setBanTimestamps(boolean banTimestamps) {
        this.banTimestamps = banTimestamps;
    }

    public String toString() {
        return String.format("RequirePluginVersions[message=%s, banLatest=%b, banRelease=%b, banSnapshots=%b, banTimestamps=%b, phases=%s, additionalPlugins=%s, unCheckedPluginList=%s, unCheckedPlugins=%s]", this.getMessage(), this.banLatest, this.banRelease, this.banSnapshots, this.banTimestamps, this.phases, this.additionalPlugins, this.unCheckedPluginList, this.unCheckedPlugins);
    }
}

