/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.checksum;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.checksum.NormalizeLineSeparatorReader;
import org.apache.maven.enforcer.rules.checksum.RequireFileChecksum;
import org.apache.maven.project.MavenProject;

@Named(value="requireTextFileChecksum")
public final class RequireTextFileChecksum
extends RequireFileChecksum {
    private NormalizeLineSeparatorReader.LineSeparator normalizeLineSeparatorTo = NormalizeLineSeparatorReader.LineSeparator.UNIX;
    private Charset encoding;
    private final MavenProject project;

    @Inject
    public RequireTextFileChecksum(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public void setNormalizeLineSeparatorTo(NormalizeLineSeparatorReader.LineSeparator normalizeLineSeparatorTo) {
        this.normalizeLineSeparatorTo = normalizeLineSeparatorTo;
    }

    public void setEncoding(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public void execute() throws EnforcerRuleException {
        if (this.encoding == null) {
            String projectEncoding = this.project.getProperties().getProperty("project.build.sourceEncoding", null);
            if (StringUtils.isBlank((CharSequence)projectEncoding)) {
                this.encoding = Charset.defaultCharset();
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + this.encoding.displayName() + ". Build is platform dependent! - https://maven.apache.org/general.html#How_do_I_prevent_.E2.80.9C.5BWARNING.5D_Using_platform_encoding_.28Cp1252_actually.29_to_copy_filtered_resources.2C_i.e._build_is_platform_dependent.21.E2.80.9D"));
            } else {
                this.encoding = Charset.forName(projectEncoding);
            }
        }
        super.execute();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String calculateChecksum() throws EnforcerRuleException {
        try (NormalizeLineSeparatorReader reader = new NormalizeLineSeparatorReader(Files.newBufferedReader(this.getFile().toPath(), this.encoding), this.normalizeLineSeparatorTo);){
            String string;
            try (ReaderInputStream inputStream = new ReaderInputStream((Reader)reader, this.encoding);){
                string = super.calculateChecksum((InputStream)inputStream);
            }
            return string;
        }
        catch (IOException e) {
            throw new EnforcerRuleError("Unable to calculate checksum (with normalized line separators)", (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return String.format("RequireFileChecksum[message=%s, file=%s, checksum=%s, type=%s, encoding=%s, normalizeLineSeparatorTo=%s, nonexistentFileMessage=%s, level=%s]", new Object[]{this.getMessage(), this.getFile(), this.getChecksum(), this.getType(), this.encoding, this.normalizeLineSeparatorTo, this.getNonexistentFileMessage(), this.getLevel()});
    }
}

