/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.text.ChoiceFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.dependency.ResolverUtil;
import org.apache.maven.enforcer.rules.utils.ArtifactMatcher;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.util.version.GenericVersionConstraint;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.VersionConstraint;

@Named(value="banDynamicVersions")
public final class BanDynamicVersions
extends AbstractStandardEnforcerRule {
    private static final String RELEASE = "RELEASE";
    private static final String LATEST = "LATEST";
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private boolean allowSnapshots;
    private boolean allowLatest;
    private boolean allowRelease;
    private boolean allowRanges;
    private boolean allowRangesWithIdenticalBounds;
    private boolean excludeOptionals;
    private List<String> excludedScopes = Collections.emptyList();
    private List<String> ignores = null;
    private boolean verbose;
    private final ResolverUtil resolverUtil;

    @Inject
    public BanDynamicVersions(MavenProject project, RepositorySystem repoSystem, MavenSession mavenSession, ResolverUtil resolverUtil) {
        this.resolverUtil = Objects.requireNonNull(resolverUtil);
    }

    public void execute() throws EnforcerRuleException {
        DependencyNode rootDependency = this.resolverUtil.resolveTransitiveDependencies(this.verbose, this.excludeOptionals, this.excludedScopes);
        List<String> violations = this.collectDependenciesWithBannedDynamicVersions(rootDependency);
        if (!violations.isEmpty()) {
            ChoiceFormat dependenciesFormat = new ChoiceFormat("1#dependency|1<dependencies");
            throw new EnforcerRuleException("Found " + violations.size() + " " + dependenciesFormat.format(violations.size()) + " with dynamic versions." + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), violations));
        }
    }

    private static String dumpIntermediatePath(Collection<DependencyNode> path) {
        if (path.isEmpty()) {
            return "";
        }
        return " via " + path.stream().map(n -> n.getArtifact().toString()).collect(Collectors.joining(" -> "));
    }

    private List<String> collectDependenciesWithBannedDynamicVersions(DependencyNode rootDependency) {
        ExcludeArtifactPatternsPredicate predicate = this.ignores != null && !this.ignores.isEmpty() ? new ExcludeArtifactPatternsPredicate(this.ignores) : d -> true;
        BannedDynamicVersionCollector collector = new BannedDynamicVersionCollector(predicate);
        rootDependency.accept((DependencyVisitor)new PathRecordingDependencyVisitor((DependencyFilter)collector));
        return collector.getViolations();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        return String.format("BanDynamicVersions[allowSnapshots=%b, allowLatest=%b, allowRelease=%b, allowRanges=%b, allowRangesWithIdenticalBounds=%b, excludeOptionals=%b, excludedScopes=%s, ignores=%s, verbose=%b]", this.allowSnapshots, this.allowLatest, this.allowRelease, this.allowRanges, this.allowRangesWithIdenticalBounds, this.excludeOptionals, this.excludedScopes, this.ignores, this.verbose);
    }

    private static final class ExcludeArtifactPatternsPredicate
    implements Predicate<DependencyNode> {
        private final ArtifactMatcher artifactMatcher;

        ExcludeArtifactPatternsPredicate(List<String> excludes) {
            this.artifactMatcher = new ArtifactMatcher(excludes, Collections.emptyList());
        }

        @Override
        public boolean test(DependencyNode depNode) {
            return !this.artifactMatcher.match(ArtifactUtils.toArtifact(depNode));
        }
    }

    private final class BannedDynamicVersionCollector
    implements DependencyFilter {
        private boolean isRoot = true;
        private List<String> violations;
        private final Predicate<DependencyNode> predicate;
        private GenericVersionScheme versionScheme;

        public List<String> getViolations() {
            return this.violations;
        }

        BannedDynamicVersionCollector(Predicate<DependencyNode> predicate) {
            this.predicate = predicate;
            this.violations = new ArrayList<String>();
            this.versionScheme = new GenericVersionScheme();
        }

        private boolean isBannedDynamicVersion(VersionConstraint versionConstraint) {
            if (versionConstraint.getVersion() != null) {
                if (versionConstraint.getVersion().toString().equals(BanDynamicVersions.LATEST)) {
                    return !BanDynamicVersions.this.allowLatest;
                }
                if (versionConstraint.getVersion().toString().equals(BanDynamicVersions.RELEASE)) {
                    return !BanDynamicVersions.this.allowRelease;
                }
                if (versionConstraint.getVersion().toString().endsWith(BanDynamicVersions.SNAPSHOT_SUFFIX)) {
                    return !BanDynamicVersions.this.allowSnapshots;
                }
            } else {
                if (versionConstraint.getRange() != null) {
                    if (BanDynamicVersions.this.allowRangesWithIdenticalBounds && Objects.equals(versionConstraint.getRange().getLowerBound(), versionConstraint.getRange().getUpperBound())) {
                        return false;
                    }
                    return !BanDynamicVersions.this.allowRanges;
                }
                BanDynamicVersions.this.getLog().warn((CharSequence)("Unexpected version constraint found: " + versionConstraint));
            }
            return false;
        }

        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            if (this.isRoot) {
                this.isRoot = false;
                return false;
            }
            BanDynamicVersions.this.getLog().debug((CharSequence)("Found node " + node + " with version constraint " + node.getVersionConstraint()));
            if (!this.predicate.test(node)) {
                return false;
            }
            VersionConstraint versionConstraint = node.getVersionConstraint();
            if (this.isBannedDynamicVersion(versionConstraint)) {
                this.addViolation(versionConstraint, node, parents);
                return true;
            }
            try {
                GenericVersionConstraint premanagedContraint;
                String premanagedVersion;
                if (BanDynamicVersions.this.verbose && (premanagedVersion = DependencyManagerUtils.getPremanagedVersion((DependencyNode)node)) != null && this.isBannedDynamicVersion((VersionConstraint)(premanagedContraint = this.versionScheme.parseVersionConstraint(premanagedVersion)))) {
                    this.addViolation((VersionConstraint)premanagedContraint, node, parents);
                    return true;
                }
            }
            catch (InvalidVersionSpecificationException ex) {
                throw new RuntimeException("Failed to parse version for " + node, ex);
            }
            return false;
        }

        private void addViolation(VersionConstraint versionContraint, DependencyNode node, List<DependencyNode> parents) {
            ArrayList<DependencyNode> intermediatePath = new ArrayList<DependencyNode>(parents);
            if (!intermediatePath.isEmpty()) {
                intermediatePath.remove(intermediatePath.size() - 1);
            }
            this.violations.add("Dependency " + node.getDependency() + BanDynamicVersions.dumpIntermediatePath(intermediatePath) + " is referenced with a banned dynamic version " + versionContraint);
        }
    }
}

