/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.PathType;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;

@Experimental
@Immutable
public interface DependencyResolverRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public RequestType getRequestType();

    @Nonnull
    public Optional<Project> getProject();

    @Nonnull
    public Optional<Artifact> getRootArtifact();

    @Nonnull
    public Optional<DependencyCoordinate> getRoot();

    @Nonnull
    public Collection<DependencyCoordinate> getDependencies();

    @Nonnull
    public Collection<DependencyCoordinate> getManagedDependencies();

    public boolean getVerbose();

    @Nullable
    public PathScope getPathScope();

    @Nullable
    public Predicate<PathType> getPathTypeFilter();

    @Nonnull
    public static DependencyResolverRequestBuilder builder() {
        return new DependencyResolverRequestBuilder();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, Artifact rootArtifact) {
        return new DependencyResolverRequestBuilder().session(session).requestType(requestType).rootArtifact(rootArtifact).pathScope(PathScope.MAIN_RUNTIME).build();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, Project project) {
        return DependencyResolverRequest.build(session, requestType, project, PathScope.MAIN_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, Project project, PathScope scope) {
        return new DependencyResolverRequestBuilder().session(session).requestType(requestType).project(project).pathScope(scope).build();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, DependencyCoordinate dependency) {
        return DependencyResolverRequest.build(session, requestType, dependency, PathScope.MAIN_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, DependencyCoordinate dependency, PathScope scope) {
        return new DependencyResolverRequestBuilder().session(session).requestType(requestType).dependency(dependency).pathScope(scope).build();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, List<DependencyCoordinate> dependencies) {
        return DependencyResolverRequest.build(session, requestType, dependencies, PathScope.MAIN_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, List<DependencyCoordinate> dependencies, PathScope scope) {
        return new DependencyResolverRequestBuilder().session(session).requestType(requestType).dependencies(dependencies).pathScope(scope).build();
    }

    @NotThreadSafe
    public static class DependencyResolverRequestBuilder {
        Session session;
        RequestType requestType;
        Project project;
        Artifact rootArtifact;
        DependencyCoordinate root;
        List<DependencyCoordinate> dependencies = Collections.emptyList();
        List<DependencyCoordinate> managedDependencies = Collections.emptyList();
        boolean verbose;
        PathScope pathScope;
        Predicate<PathType> pathTypeFilter;

        DependencyResolverRequestBuilder() {
        }

        @Nonnull
        public DependencyResolverRequestBuilder session(@Nonnull Session session) {
            this.session = session;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder requestType(@Nonnull RequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder project(@Nullable Project project) {
            this.project = project;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder rootArtifact(@Nullable Artifact rootArtifact) {
            this.rootArtifact = rootArtifact;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder root(@Nonnull DependencyCoordinate root) {
            this.root = root;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder dependencies(@Nullable List<DependencyCoordinate> dependencies) {
            this.dependencies = dependencies != null ? dependencies : Collections.emptyList();
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder dependency(@Nullable DependencyCoordinate dependency) {
            if (dependency != null) {
                if (this.dependencies.isEmpty()) {
                    this.dependencies = new ArrayList<DependencyCoordinate>();
                }
                this.dependencies.add(dependency);
            }
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder managedDependencies(@Nullable List<DependencyCoordinate> managedDependencies) {
            this.managedDependencies = managedDependencies != null ? managedDependencies : Collections.emptyList();
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder managedDependency(@Nullable DependencyCoordinate managedDependency) {
            if (managedDependency != null) {
                if (this.managedDependencies.isEmpty()) {
                    this.managedDependencies = new ArrayList<DependencyCoordinate>();
                }
                this.managedDependencies.add(managedDependency);
            }
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder pathScope(@Nullable PathScope pathScope) {
            this.pathScope = pathScope;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder pathTypeFilter(@Nonnull Predicate<PathType> pathTypeFilter) {
            this.pathTypeFilter = pathTypeFilter;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder pathTypeFilter(@Nonnull Collection<? extends PathType> desiredTypes) {
            return this.pathTypeFilter(desiredTypes::contains);
        }

        @Nonnull
        public DependencyResolverRequest build() {
            return new DefaultDependencyResolverRequest(this.session, this.requestType, this.project, this.rootArtifact, this.root, this.dependencies, this.managedDependencies, this.verbose, this.pathScope, this.pathTypeFilter);
        }

        static class DefaultDependencyResolverRequest
        extends BaseRequest
        implements DependencyResolverRequest {
            private final RequestType requestType;
            private final Project project;
            private final Artifact rootArtifact;
            private final DependencyCoordinate root;
            private final Collection<DependencyCoordinate> dependencies;
            private final Collection<DependencyCoordinate> managedDependencies;
            private final boolean verbose;
            private final PathScope pathScope;
            private final Predicate<PathType> pathTypeFilter;

            DefaultDependencyResolverRequest(@Nonnull Session session, @Nonnull RequestType requestType, @Nullable Project project, @Nullable Artifact rootArtifact, @Nullable DependencyCoordinate root, @Nonnull Collection<DependencyCoordinate> dependencies, @Nonnull Collection<DependencyCoordinate> managedDependencies, boolean verbose, @Nullable PathScope pathScope, @Nullable Predicate<PathType> pathTypeFilter) {
                super(session);
                this.requestType = DefaultDependencyResolverRequest.nonNull(requestType, "requestType cannot be null");
                this.project = project;
                this.rootArtifact = rootArtifact;
                this.root = root;
                this.dependencies = DefaultDependencyResolverRequest.unmodifiable(DefaultDependencyResolverRequest.nonNull(dependencies, "dependencies cannot be null"));
                this.managedDependencies = DefaultDependencyResolverRequest.unmodifiable(DefaultDependencyResolverRequest.nonNull(managedDependencies, "managedDependencies cannot be null"));
                this.verbose = verbose;
                this.pathScope = pathScope;
                Predicate<PathType> predicate = this.pathTypeFilter = pathTypeFilter != null ? pathTypeFilter : t -> true;
                if (verbose && requestType != RequestType.COLLECT) {
                    throw new IllegalArgumentException("verbose cannot only be true when collecting dependencies");
                }
            }

            @Override
            @Nonnull
            public RequestType getRequestType() {
                return this.requestType;
            }

            @Override
            @Nonnull
            public Optional<Project> getProject() {
                return Optional.ofNullable(this.project);
            }

            @Override
            @Nonnull
            public Optional<Artifact> getRootArtifact() {
                return Optional.ofNullable(this.rootArtifact);
            }

            @Override
            @Nonnull
            public Optional<DependencyCoordinate> getRoot() {
                return Optional.ofNullable(this.root);
            }

            @Override
            @Nonnull
            public Collection<DependencyCoordinate> getDependencies() {
                return this.dependencies;
            }

            @Override
            @Nonnull
            public Collection<DependencyCoordinate> getManagedDependencies() {
                return this.managedDependencies;
            }

            @Override
            public boolean getVerbose() {
                return this.verbose;
            }

            @Override
            public PathScope getPathScope() {
                return this.pathScope;
            }

            @Override
            public Predicate<PathType> getPathTypeFilter() {
                return this.pathTypeFilter;
            }

            @Nonnull
            public String toString() {
                return this.getRoot() + " -> " + this.getDependencies();
            }
        }
    }

    public static enum RequestType {
        COLLECT,
        FLATTEN,
        RESOLVE;

    }
}

