/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Source;

@Experimental
@Immutable
public interface SettingsBuilderRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public Optional<Source> getGlobalSettingsSource();

    @Nonnull
    public Optional<Source> getProjectSettingsSource();

    @Nonnull
    public Optional<Source> getUserSettingsSource();

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull Session session, @Nonnull Source globalSettingsSource, @Nonnull Source userSettingsSource) {
        return SettingsBuilderRequest.build(session, globalSettingsSource, null, userSettingsSource);
    }

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull Session session, @Nonnull Path globalSettingsPath, @Nonnull Path userSettingsPath) {
        return SettingsBuilderRequest.build(session, Source.fromPath(globalSettingsPath), null, Source.fromPath(userSettingsPath));
    }

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull Session session, @Nullable Source globalSettingsSource, @Nullable Source projectSettingsSource, @Nullable Source userSettingsSource) {
        return SettingsBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).globalSettingsSource(globalSettingsSource).projectSettingsSource(projectSettingsSource).userSettingsSource(userSettingsSource).build();
    }

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull Session session, @Nullable Path globalSettingsPath, @Nullable Path projectSettingsPath, @Nullable Path userSettingsPath) {
        return SettingsBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).globalSettingsSource(globalSettingsPath != null && Files.exists(globalSettingsPath, new LinkOption[0]) ? Source.fromPath(globalSettingsPath) : null).projectSettingsSource(projectSettingsPath != null && Files.exists(projectSettingsPath, new LinkOption[0]) ? Source.fromPath(projectSettingsPath) : null).userSettingsSource(userSettingsPath != null && Files.exists(userSettingsPath, new LinkOption[0]) ? Source.fromPath(userSettingsPath) : null).build();
    }

    @Nonnull
    public static SettingsBuilderRequestBuilder builder() {
        return new SettingsBuilderRequestBuilder();
    }

    @NotThreadSafe
    public static class SettingsBuilderRequestBuilder {
        Session session;
        Source globalSettingsSource;
        Source projectSettingsSource;
        Source userSettingsSource;

        public SettingsBuilderRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public SettingsBuilderRequestBuilder globalSettingsSource(Source globalSettingsSource) {
            this.globalSettingsSource = globalSettingsSource;
            return this;
        }

        public SettingsBuilderRequestBuilder projectSettingsSource(Source projectSettingsSource) {
            this.projectSettingsSource = projectSettingsSource;
            return this;
        }

        public SettingsBuilderRequestBuilder userSettingsSource(Source userSettingsSource) {
            this.userSettingsSource = userSettingsSource;
            return this;
        }

        public SettingsBuilderRequest build() {
            return new DefaultSettingsBuilderRequest(this.session, this.globalSettingsSource, this.projectSettingsSource, this.userSettingsSource);
        }

        private static class DefaultSettingsBuilderRequest
        extends BaseRequest
        implements SettingsBuilderRequest {
            private final Source globalSettingsSource;
            private final Source projectSettingsSource;
            private final Source userSettingsSource;

            DefaultSettingsBuilderRequest(@Nonnull Session session, @Nullable Source globalSettingsSource, @Nullable Source projectSettingsSource, @Nullable Source userSettingsSource) {
                super(session);
                this.globalSettingsSource = globalSettingsSource;
                this.projectSettingsSource = projectSettingsSource;
                this.userSettingsSource = userSettingsSource;
            }

            @Override
            @Nonnull
            public Optional<Source> getGlobalSettingsSource() {
                return Optional.ofNullable(this.globalSettingsSource);
            }

            @Override
            @Nonnull
            public Optional<Source> getProjectSettingsSource() {
                return Optional.ofNullable(this.projectSettingsSource);
            }

            @Override
            @Nonnull
            public Optional<Source> getUserSettingsSource() {
                return Optional.ofNullable(this.userSettingsSource);
            }
        }
    }
}

