/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.services.BaseRequest;

@Experimental
public interface VersionResolverRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public ArtifactCoordinate getArtifactCoordinate();

    @Nonnull
    public static VersionResolverRequest build(@Nonnull Session session, @Nonnull ArtifactCoordinate artifactCoordinate) {
        return VersionResolverRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).artifactCoordinate(BaseRequest.nonNull(artifactCoordinate, "artifactCoordinate cannot be null")).build();
    }

    @Nonnull
    public static VersionResolverRequestBuilder builder() {
        return new VersionResolverRequestBuilder();
    }

    @NotThreadSafe
    public static class VersionResolverRequestBuilder {
        Session session;
        ArtifactCoordinate artifactCoordinate;

        public VersionResolverRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public VersionResolverRequestBuilder artifactCoordinate(ArtifactCoordinate artifactCoordinate) {
            this.artifactCoordinate = artifactCoordinate;
            return this;
        }

        public VersionResolverRequest build() {
            return new DefaultVersionResolverRequest(this.session, this.artifactCoordinate);
        }

        private static class DefaultVersionResolverRequest
        extends BaseRequest
        implements VersionResolverRequest {
            private final ArtifactCoordinate artifactCoordinate;

            DefaultVersionResolverRequest(@Nonnull Session session, @Nonnull ArtifactCoordinate artifactCoordinate) {
                super(session);
                this.artifactCoordinate = artifactCoordinate;
            }

            @Override
            @Nonnull
            public ArtifactCoordinate getArtifactCoordinate() {
                return this.artifactCoordinate;
            }
        }
    }
}

