/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.spi.ModelParserException;
import org.apache.maven.internal.impl.model.DefaultModelBuilderResult;
import org.apache.maven.internal.impl.model.DefaultModelProblem;
import org.apache.maven.internal.impl.model.ModelProblemUtils;

class DefaultModelProblemCollector
implements ModelProblemCollector {
    private final ModelBuilderResult result;
    private List<ModelProblem> problems;
    private String source;
    private Model sourceModel;
    private Model rootModel;
    private Set<BuilderProblem.Severity> severities = EnumSet.noneOf(BuilderProblem.Severity.class);

    DefaultModelProblemCollector(ModelBuilderResult result) {
        this.result = result;
        this.problems = result.getProblems();
        for (ModelProblem problem : this.problems) {
            this.severities.add(problem.getSeverity());
        }
    }

    public boolean hasFatalErrors() {
        return this.severities.contains(BuilderProblem.Severity.FATAL);
    }

    public boolean hasErrors() {
        return this.severities.contains(BuilderProblem.Severity.ERROR) || this.severities.contains(BuilderProblem.Severity.FATAL);
    }

    public List<ModelProblem> getProblems() {
        return this.problems;
    }

    public void setSource(String source) {
        this.source = source;
        this.sourceModel = null;
    }

    public void setSource(Model source) {
        this.sourceModel = source;
        this.source = null;
        if (this.rootModel == null) {
            this.rootModel = source;
        }
    }

    private String getSource() {
        if (this.source == null && this.sourceModel != null) {
            this.source = ModelProblemUtils.toPath(this.sourceModel);
        }
        return this.source;
    }

    private String getModelId() {
        return ModelProblemUtils.toId(this.sourceModel);
    }

    public void setRootModel(Model rootModel) {
        this.rootModel = rootModel;
    }

    public Model getRootModel() {
        return this.rootModel;
    }

    public String getRootModelId() {
        return ModelProblemUtils.toId(this.rootModel);
    }

    public void add(ModelProblem problem) {
        this.problems.add(problem);
        this.severities.add(problem.getSeverity());
    }

    public void addAll(Collection<ModelProblem> problems) {
        this.problems.addAll(problems);
        for (ModelProblem problem : problems) {
            this.severities.add(problem.getSeverity());
        }
    }

    public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message) {
        this.add(severity, version, message, null, null);
    }

    public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message, InputLocation location) {
        this.add(severity, version, message, location, null);
    }

    public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message, Exception exception) {
        this.add(severity, version, message, null, exception);
    }

    public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message, InputLocation location, Exception exception) {
        int line = -1;
        int column = -1;
        String source = null;
        String modelId = null;
        if (location != null) {
            line = location.getLineNumber();
            column = location.getColumnNumber();
            if (location.getSource() != null) {
                modelId = location.getSource().getModelId();
                source = location.getSource().getLocation();
            }
        }
        if (modelId == null) {
            modelId = this.getModelId();
            source = this.getSource();
        }
        if (line <= 0 && column <= 0 && exception instanceof ModelParserException) {
            ModelParserException e = (ModelParserException)exception;
            line = e.getLineNumber();
            column = e.getColumnNumber();
        }
        DefaultModelProblem problem = new DefaultModelProblem(message, severity, version, source, line, column, modelId, exception);
        this.add(problem);
    }

    public ModelBuilderException newModelBuilderException() {
        ModelBuilderResult result = this.result;
        if (result.getModelIds().isEmpty()) {
            DefaultModelBuilderResult tmp = new DefaultModelBuilderResult();
            tmp.setEffectiveModel(result.getEffectiveModel());
            tmp.setProblems(this.getProblems());
            tmp.setActiveExternalProfiles(result.getActiveExternalProfiles());
            String id = this.getRootModelId();
            tmp.addModelId(id);
            tmp.setRawModel(id, this.getRootModel());
            result = tmp;
        }
        return new ModelBuilderException(result);
    }
}

