/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.Session;
import org.apache.maven.api.Version;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.ModelResolver;
import org.apache.maven.api.services.ModelResolverException;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.VersionRangeResolverException;

@Named
@Singleton
public class DefaultModelResolver
implements ModelResolver {
    public ModelSource resolveModel(Session session, String groupId, String artifactId, String version, Consumer<String> resolvedVersion) throws ModelResolverException {
        try {
            ArtifactCoordinate coord = session.createArtifactCoordinate(groupId, artifactId, version, "pom");
            if (coord.getVersion().getVersionRange() != null && coord.getVersion().getVersionRange().getUpperBoundary() == null) {
                throw new ModelResolverException(String.format("The requested version range '%s' does not specify an upper bound", version), groupId, artifactId, version);
            }
            List versions = session.resolveVersionRange(coord);
            if (versions.isEmpty()) {
                throw new ModelResolverException(String.format("No versions matched the requested version range '%s'", version), groupId, artifactId, version);
            }
            String newVersion = ((Version)versions.get(versions.size() - 1)).asString();
            if (!version.equals(newVersion)) {
                resolvedVersion.accept(newVersion);
            }
            Map.Entry resolved = session.resolveArtifact(session.createArtifactCoordinate(groupId, artifactId, newVersion, "pom"));
            return ModelSource.fromPath((Path)((Path)resolved.getValue()), (String)(groupId + ":" + artifactId + ":" + newVersion));
        }
        catch (ArtifactResolverException | VersionRangeResolverException e) {
            throw new ModelResolverException(e.getMessage() + " (remote repositories: " + session.getRemoteRepositories().stream().map(Object::toString).collect(Collectors.joining(", ")) + ")", groupId, artifactId, version, e);
        }
    }
}

