/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.maven.api.metadata.Metadata;
import org.apache.maven.api.metadata.Snapshot;
import org.apache.maven.api.metadata.SnapshotVersion;
import org.apache.maven.api.metadata.Versioning;
import org.apache.maven.internal.impl.resolver.MavenMetadata;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;

final class LocalSnapshotMetadata
extends MavenMetadata {
    private final Collection<Artifact> artifacts = new ArrayList<Artifact>();

    LocalSnapshotMetadata(Artifact artifact, Date timestamp) {
        super(LocalSnapshotMetadata.createMetadata(artifact), (Path)null, timestamp);
    }

    LocalSnapshotMetadata(Metadata metadata, Path path, Date timestamp) {
        super(metadata, path, timestamp);
    }

    private static Metadata createMetadata(Artifact artifact) {
        Snapshot snapshot = Snapshot.newBuilder().localCopy(true).build();
        Versioning versioning = Versioning.newBuilder().snapshot(snapshot).build();
        Metadata metadata = Metadata.newBuilder().versioning(versioning).groupId(artifact.getGroupId()).artifactId(artifact.getArtifactId()).version(artifact.getBaseVersion()).modelVersion("1.1.0").build();
        return metadata;
    }

    public void bind(Artifact artifact) {
        this.artifacts.add(artifact);
    }

    @Deprecated
    public MavenMetadata setFile(File file) {
        return new LocalSnapshotMetadata(this.metadata, file.toPath(), this.timestamp);
    }

    public MavenMetadata setPath(Path path) {
        return new LocalSnapshotMetadata(this.metadata, path, this.timestamp);
    }

    public Object getKey() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    public static Object getKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
    }

    @Override
    protected void merge(Metadata recessive) {
        this.metadata = this.metadata.withVersioning(this.metadata.getVersioning().withLastUpdated(fmt.format(this.timestamp)));
        String lastUpdated = this.metadata.getVersioning().getLastUpdated();
        LinkedHashMap<String, SnapshotVersion> versions = new LinkedHashMap<String, SnapshotVersion>();
        for (Artifact artifact : this.artifacts) {
            SnapshotVersion sv = SnapshotVersion.newBuilder().classifier(artifact.getClassifier()).extension(artifact.getExtension()).version(this.getVersion()).updated(lastUpdated).build();
            versions.put(this.getKey(sv.getClassifier(), sv.getExtension()), sv);
        }
        Versioning versioning = recessive.getVersioning();
        if (versioning != null) {
            for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
                String key = this.getKey(sv.getClassifier(), sv.getExtension());
                if (versions.containsKey(key)) continue;
                versions.put(key, sv);
            }
        }
        this.metadata = this.metadata.withVersioning(this.metadata.getVersioning().withSnapshotVersions(versions.values()));
        if (recessive.getPlugins() != null && !recessive.getPlugins().isEmpty()) {
            this.metadata = this.metadata.withPlugins(new ArrayList(recessive.getPlugins()));
        }
        this.artifacts.clear();
    }

    private String getKey(String classifier, String extension) {
        return classifier + ":" + extension;
    }

    public String getGroupId() {
        return this.metadata.getGroupId();
    }

    public String getArtifactId() {
        return this.metadata.getArtifactId();
    }

    public String getVersion() {
        return this.metadata.getVersion();
    }

    public Metadata.Nature getNature() {
        return Metadata.Nature.SNAPSHOT;
    }
}

