/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Dependency
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final String type;
    final String classifier;
    final String scope;
    final String systemPath;
    final List<Exclusion> exclusions;
    final String optional;
    final Map<Object, InputLocation> locations;
    private volatile String managementKey;

    Dependency(String groupId, String artifactId, String version, String type, String classifier, String scope, String systemPath, Collection<Exclusion> exclusions, String optional, Map<Object, InputLocation> locations) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
        this.scope = scope;
        this.systemPath = systemPath;
        this.exclusions = ImmutableCollections.copy(exclusions);
        this.optional = optional;
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getScope() {
        return this.scope;
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    @Nonnull
    public List<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public String getOptional() {
        return this.optional;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Dependency.newBuilder(this);
    }

    @Nonnull
    public Dependency withGroupId(String groupId) {
        return Dependency.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public Dependency withArtifactId(String artifactId) {
        return Dependency.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public Dependency withVersion(String version) {
        return Dependency.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public Dependency withType(String type) {
        return Dependency.newBuilder(this, true).type(type).build();
    }

    @Nonnull
    public Dependency withClassifier(String classifier) {
        return Dependency.newBuilder(this, true).classifier(classifier).build();
    }

    @Nonnull
    public Dependency withScope(String scope) {
        return Dependency.newBuilder(this, true).scope(scope).build();
    }

    @Nonnull
    public Dependency withSystemPath(String systemPath) {
        return Dependency.newBuilder(this, true).systemPath(systemPath).build();
    }

    @Nonnull
    public Dependency withExclusions(Collection<Exclusion> exclusions) {
        return Dependency.newBuilder(this, true).exclusions(exclusions).build();
    }

    @Nonnull
    public Dependency withOptional(String optional) {
        return Dependency.newBuilder(this, true).optional(optional).build();
    }

    @Nonnull
    public static Dependency newInstance() {
        return Dependency.newInstance(true);
    }

    @Nonnull
    public static Dependency newInstance(boolean withDefaults) {
        return Dependency.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Dependency.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Dependency from) {
        return Dependency.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Dependency from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isOptional() {
        return this.getOptional() != null ? Boolean.parseBoolean(this.getOptional()) : false;
    }

    public String toString() {
        return "Dependency {groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", type=" + this.getType() + "}";
    }

    public String getManagementKey() {
        if (this.managementKey == null) {
            this.managementKey = this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + (String)(this.getClassifier() != null ? ":" + this.getClassifier() : "");
        }
        return this.managementKey;
    }

    @NotThreadSafe
    public static class Builder {
        Dependency base;
        String groupId;
        String artifactId;
        String version;
        String type;
        String classifier;
        String scope;
        String systemPath;
        Collection<Exclusion> exclusions;
        String optional;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.type = "jar";
            }
        }

        Builder(Dependency base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.type = base.type;
                this.classifier = base.classifier;
                this.scope = base.scope;
                this.systemPath = base.systemPath;
                this.exclusions = base.exclusions;
                this.optional = base.optional;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public Builder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        @Nonnull
        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Nonnull
        public Builder systemPath(String systemPath) {
            this.systemPath = systemPath;
            return this;
        }

        @Nonnull
        public Builder exclusions(Collection<Exclusion> exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        @Nonnull
        public Builder optional(String optional) {
            this.optional = optional;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Dependency build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.type != null && this.type != this.base.type || this.classifier != null && this.classifier != this.base.classifier || this.scope != null && this.scope != this.base.scope || this.systemPath != null && this.systemPath != this.base.systemPath || this.exclusions != null && this.exclusions != this.base.exclusions || this.optional != null && this.optional != this.base.optional)) {
                return this.base;
            }
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("groupId", newlocs.containsKey("groupId") ? (InputLocation)newlocs.get("groupId") : (InputLocation)oldlocs.get("groupId"));
            locations.put("artifactId", newlocs.containsKey("artifactId") ? (InputLocation)newlocs.get("artifactId") : (InputLocation)oldlocs.get("artifactId"));
            locations.put("version", newlocs.containsKey("version") ? (InputLocation)newlocs.get("version") : (InputLocation)oldlocs.get("version"));
            locations.put("type", newlocs.containsKey("type") ? (InputLocation)newlocs.get("type") : (InputLocation)oldlocs.get("type"));
            locations.put("classifier", newlocs.containsKey("classifier") ? (InputLocation)newlocs.get("classifier") : (InputLocation)oldlocs.get("classifier"));
            locations.put("scope", newlocs.containsKey("scope") ? (InputLocation)newlocs.get("scope") : (InputLocation)oldlocs.get("scope"));
            locations.put("systemPath", newlocs.containsKey("systemPath") ? (InputLocation)newlocs.get("systemPath") : (InputLocation)oldlocs.get("systemPath"));
            locations.put("exclusions", newlocs.containsKey("exclusions") ? (InputLocation)newlocs.get("exclusions") : (InputLocation)oldlocs.get("exclusions"));
            locations.put("optional", newlocs.containsKey("optional") ? (InputLocation)newlocs.get("optional") : (InputLocation)oldlocs.get("optional"));
            return new Dependency(this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.type != null ? this.type : (this.base != null ? this.base.type : null), this.classifier != null ? this.classifier : (this.base != null ? this.base.classifier : null), this.scope != null ? this.scope : (this.base != null ? this.base.scope : null), this.systemPath != null ? this.systemPath : (this.base != null ? this.base.systemPath : null), this.exclusions != null ? this.exclusions : (this.base != null ? this.base.exclusions : null), this.optional != null ? this.optional : (this.base != null ? this.base.optional : null), locations);
        }
    }
}

