/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PatternSet
implements Serializable,
InputLocationTracker {
    final List<String> includes;
    final List<String> excludes;
    final Map<Object, InputLocation> locations;

    PatternSet(Collection<String> includes, Collection<String> excludes, Map<Object, InputLocation> locations) {
        this.includes = ImmutableCollections.copy(includes);
        this.excludes = ImmutableCollections.copy(excludes);
        this.locations = ImmutableCollections.copy(locations);
    }

    @Nonnull
    public List<String> getIncludes() {
        return this.includes;
    }

    @Nonnull
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return PatternSet.newBuilder(this);
    }

    @Nonnull
    public PatternSet withIncludes(Collection<String> includes) {
        return PatternSet.newBuilder(this, true).includes(includes).build();
    }

    @Nonnull
    public PatternSet withExcludes(Collection<String> excludes) {
        return PatternSet.newBuilder(this, true).excludes(excludes).build();
    }

    @Nonnull
    public static PatternSet newInstance() {
        return PatternSet.newInstance(true);
    }

    @Nonnull
    public static PatternSet newInstance(boolean withDefaults) {
        return PatternSet.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PatternSet.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PatternSet from) {
        return PatternSet.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PatternSet from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return "PatternSet [includes: {" + this.getIncludes().stream().collect(Collectors.joining(", ")) + "}, excludes: {" + this.getExcludes().stream().collect(Collectors.joining(", ")) + "}]";
    }

    @NotThreadSafe
    public static class Builder {
        PatternSet base;
        Collection<String> includes;
        Collection<String> excludes;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(PatternSet base, boolean forceCopy) {
            if (forceCopy) {
                this.includes = base.includes;
                this.excludes = base.excludes;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder includes(Collection<String> includes) {
            this.includes = includes;
            return this;
        }

        @Nonnull
        public Builder excludes(Collection<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public PatternSet build() {
            if (!(this.base == null || this.includes != null && this.includes != this.base.includes || this.excludes != null && this.excludes != this.base.excludes)) {
                return this.base;
            }
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("includes", newlocs.containsKey("includes") ? (InputLocation)newlocs.get("includes") : (InputLocation)oldlocs.get("includes"));
            locations.put("excludes", newlocs.containsKey("excludes") ? (InputLocation)newlocs.get("excludes") : (InputLocation)oldlocs.get("excludes"));
            return new PatternSet(this.includes != null ? this.includes : (this.base != null ? this.base.includes : null), this.excludes != null ? this.excludes : (this.base != null ? this.base.excludes : null), locations);
        }
    }
}

