/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class RepositoryPolicy
implements Serializable,
InputLocationTracker {
    final String enabled;
    final String updatePolicy;
    final String checksumPolicy;
    final Map<Object, InputLocation> locations;

    RepositoryPolicy(String enabled, String updatePolicy, String checksumPolicy, Map<Object, InputLocation> locations) {
        this.enabled = enabled;
        this.updatePolicy = updatePolicy;
        this.checksumPolicy = checksumPolicy;
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getEnabled() {
        return this.enabled;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return RepositoryPolicy.newBuilder(this);
    }

    @Nonnull
    public RepositoryPolicy withEnabled(String enabled) {
        return RepositoryPolicy.newBuilder(this, true).enabled(enabled).build();
    }

    @Nonnull
    public RepositoryPolicy withUpdatePolicy(String updatePolicy) {
        return RepositoryPolicy.newBuilder(this, true).updatePolicy(updatePolicy).build();
    }

    @Nonnull
    public RepositoryPolicy withChecksumPolicy(String checksumPolicy) {
        return RepositoryPolicy.newBuilder(this, true).checksumPolicy(checksumPolicy).build();
    }

    @Nonnull
    public static RepositoryPolicy newInstance() {
        return RepositoryPolicy.newInstance(true);
    }

    @Nonnull
    public static RepositoryPolicy newInstance(boolean withDefaults) {
        return RepositoryPolicy.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return RepositoryPolicy.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryPolicy from) {
        return RepositoryPolicy.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryPolicy from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isEnabled() {
        return this.getEnabled() != null ? Boolean.parseBoolean(this.getEnabled()) : true;
    }

    @NotThreadSafe
    public static class Builder {
        RepositoryPolicy base;
        String enabled;
        String updatePolicy;
        String checksumPolicy;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(RepositoryPolicy base, boolean forceCopy) {
            if (forceCopy) {
                this.enabled = base.enabled;
                this.updatePolicy = base.updatePolicy;
                this.checksumPolicy = base.checksumPolicy;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder enabled(String enabled) {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        public Builder updatePolicy(String updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        @Nonnull
        public Builder checksumPolicy(String checksumPolicy) {
            this.checksumPolicy = checksumPolicy;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public RepositoryPolicy build() {
            if (!(this.base == null || this.enabled != null && this.enabled != this.base.enabled || this.updatePolicy != null && this.updatePolicy != this.base.updatePolicy || this.checksumPolicy != null && this.checksumPolicy != this.base.checksumPolicy)) {
                return this.base;
            }
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("enabled", newlocs.containsKey("enabled") ? (InputLocation)newlocs.get("enabled") : (InputLocation)oldlocs.get("enabled"));
            locations.put("updatePolicy", newlocs.containsKey("updatePolicy") ? (InputLocation)newlocs.get("updatePolicy") : (InputLocation)oldlocs.get("updatePolicy"));
            locations.put("checksumPolicy", newlocs.containsKey("checksumPolicy") ? (InputLocation)newlocs.get("checksumPolicy") : (InputLocation)oldlocs.get("checksumPolicy"));
            return new RepositoryPolicy(this.enabled != null ? this.enabled : (this.base != null ? this.base.enabled : null), this.updatePolicy != null ? this.updatePolicy : (this.base != null ? this.base.updatePolicy : null), this.checksumPolicy != null ? this.checksumPolicy : (this.base != null ? this.base.checksumPolicy : null), locations);
        }
    }
}

