/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr.pacman;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.FileManager;
import org.apache.maven.jxr.pacman.JavaFile;
import org.apache.maven.jxr.pacman.PackageType;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageManager.class);
    private final FileManager fileManager;
    private Set<Path> directories = new HashSet<Path>();
    private Map<String, PackageType> packages = new HashMap<String, PackageType>();
    private PackageType defaultPackage = new PackageType();
    private String[] excludes = null;
    private String[] includes = new String[]{"**/*.java"};

    public PackageManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public PackageType getPackageType(String name) {
        if (name == null) {
            return this.defaultPackage;
        }
        return this.packages.get(name);
    }

    public void addPackageType(PackageType packageType) {
        this.packages.put(packageType.getName(), packageType);
    }

    public Collection<PackageType> getPackageTypes() {
        return this.packages.values();
    }

    private void parse(Path baseDir) {
        LOGGER.debug("Scanning " + baseDir);
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(baseDir.toFile());
        directoryScanner.setExcludes(this.excludes);
        directoryScanner.setIncludes(this.includes);
        directoryScanner.scan();
        for (String file : directoryScanner.getIncludedFiles()) {
            LOGGER.debug("parsing... " + file);
            try {
                Path fileName = baseDir.resolve(file);
                JavaFile jfi = this.fileManager.getFile(fileName);
                PackageType jp = this.getPackageType(jfi.getPackageType().getName());
                if (jp == null) {
                    this.addPackageType(jfi.getPackageType());
                    jp = jfi.getPackageType();
                }
                if (jfi.getClassTypes() == null || jfi.getClassTypes().isEmpty()) continue;
                for (ClassType ct : jfi.getClassTypes()) {
                    jp.addClassType(ct);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void process(Path directory) {
        if (this.directories.add(directory)) {
            this.parse(directory);
        }
    }

    public void dump() {
        LOGGER.debug("Dumping out PackageManager structure");
        for (PackageType current : this.getPackageTypes()) {
            LOGGER.debug(current.getName());
            for (ClassType currentClass : current.getClassTypes()) {
                LOGGER.debug('\t' + currentClass.getName());
            }
        }
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }
}

