/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.nio.file.Path;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;

public class ModelProblemUtils {
    static String toSourceHint(Model model) {
        if (model == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(ModelProblemUtils.toId(model));
        Path pomPath = model.getPomPath();
        if (pomPath != null) {
            buffer.append(" (").append(pomPath).append(')');
        }
        return buffer.toString();
    }

    static String toPath(Model model) {
        Path pomPath;
        String path = "";
        if (model != null && (pomPath = model.getPomPath()) != null) {
            path = pomPath.toAbsolutePath().toString();
        }
        return path;
    }

    static String toId(Model model) {
        if (model == null) {
            return "";
        }
        return ModelProblemUtils.toId(model.getDelegate());
    }

    static String toId(org.apache.maven.api.model.Model model) {
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        String artifactId = model.getArtifactId();
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        if (version == null) {
            version = "[unknown-version]";
        }
        return ModelProblemUtils.toId(groupId, artifactId, version);
    }

    static String toId(String groupId, String artifactId, String version) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(groupId != null && !groupId.isEmpty() ? groupId : "[unknown-group-id]");
        buffer.append(':');
        buffer.append(artifactId != null && !artifactId.isEmpty() ? artifactId : "[unknown-artifact-id]");
        buffer.append(':');
        buffer.append(version != null && !version.isEmpty() ? version : "[unknown-version]");
        return buffer.toString();
    }

    public static String formatLocation(ModelProblem problem, String projectId) {
        StringBuilder buffer = new StringBuilder(256);
        if (!problem.getModelId().equals(projectId)) {
            buffer.append(problem.getModelId());
            if (!problem.getSource().isEmpty()) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(problem.getSource());
            }
        }
        if (problem.getLineNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("line ").append(problem.getLineNumber());
        }
        if (problem.getColumnNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("column ").append(problem.getColumnNumber());
        }
        return buffer.toString();
    }
}

