/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.interpolation;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.AbstractStringBasedModelInterpolator;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.apache.maven.model.root.RootLocator;
import org.apache.maven.model.v4.MavenTransformer;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

@Named
@Singleton
public class StringVisitorModelInterpolator
extends AbstractStringBasedModelInterpolator {
    @Inject
    public StringVisitorModelInterpolator(PathTranslator pathTranslator, UrlNormalizer urlNormalizer, RootLocator rootLocator) {
        super(pathTranslator, urlNormalizer, rootLocator);
    }

    @Override
    @Deprecated
    public Model interpolateModel(Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        return this.interpolateModel(model, projectDir != null ? projectDir.toPath() : null, config, problems);
    }

    @Override
    public Model interpolateModel(Model model, Path projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        List<ValueSource> valueSources = this.createValueSources(model, projectDir, config, problems);
        List<? extends InterpolationPostProcessor> postProcessors = this.createPostProcessors(model, projectDir, config);
        InnerInterpolator innerInterpolator = this.createInterpolator(valueSources, postProcessors, problems, config);
        return new MavenTransformer(innerInterpolator::interpolate).visit(model);
    }

    private InnerInterpolator createInterpolator(List<? extends ValueSource> valueSources, List<? extends InterpolationPostProcessor> postProcessors, ModelProblemCollector problems, ModelBuildingRequest config) {
        HashMap cache = new HashMap();
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setCacheAnswers(true);
        for (ValueSource valueSource : valueSources) {
            interpolator.addValueSource(valueSource);
        }
        for (InterpolationPostProcessor interpolationPostProcessor : postProcessors) {
            interpolator.addPostProcessor(interpolationPostProcessor);
        }
        RecursionInterceptor recursionInterceptor = this.createRecursionInterceptor(config);
        return value -> {
            if (value != null && value.contains("${")) {
                String c = (String)cache.get(value);
                if (c == null) {
                    try {
                        c = interpolator.interpolate(value, recursionInterceptor);
                    }
                    catch (InterpolationException e) {
                        problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(e.getMessage()).setException((Exception)((Object)e)));
                    }
                    cache.put(value, c);
                }
                return c;
            }
            return value;
        };
    }

    static interface InnerInterpolator {
        public String interpolate(String var1);
    }
}

