/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Goal;
import org.apache.maven.model.PluginExecution;

public class Plugin
extends ConfigurationContainer
implements Serializable {
    private String groupId = "org.apache.maven.plugins";
    private String artifactId;
    private String version;
    private List executions;
    private List goals;
    private Map executionMap = null;
    private Map goalMap = null;

    public void addExecution(PluginExecution pluginExecution) {
        this.getExecutions().add(pluginExecution);
    }

    public void addGoal(Goal goal) {
        this.getGoals().add(goal);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public List getExecutions() {
        if (this.executions == null) {
            this.executions = new ArrayList();
        }
        return this.executions;
    }

    public List getGoals() {
        if (this.goals == null) {
            this.goals = new ArrayList();
        }
        return this.goals;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeExecution(PluginExecution pluginExecution) {
        this.getExecutions().remove(pluginExecution);
    }

    public void removeGoal(Goal goal) {
        this.getGoals().remove(goal);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setExecutions(List executions) {
        this.executions = executions;
    }

    public void setGoals(List goals) {
        this.goals = goals;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void flushExecutionMap() {
        this.executionMap = null;
    }

    public Map getExecutionsAsMap() {
        if (this.executionMap == null) {
            this.executionMap = new HashMap();
            if (this.getExecutions() != null) {
                Iterator i = this.getExecutions().iterator();
                while (i.hasNext()) {
                    PluginExecution exec = (PluginExecution)i.next();
                    if (this.executionMap.containsKey(exec.getId())) {
                        throw new IllegalStateException("You cannot have two plugin executions with the same (or missing) <id/> elements.\nOffending execution\n\nId: '" + exec.getId() + "'\nPlugin:'" + this.getKey() + "'\n\n");
                    }
                    this.executionMap.put(exec.getId(), exec);
                }
            }
        }
        return this.executionMap;
    }

    public String getKey() {
        return Plugin.constructKey(this.groupId, this.artifactId);
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public void flushGoalMap() {
        this.goalMap = null;
    }

    public Map getGoalsAsMap() {
        if (this.goalMap == null) {
            this.goalMap = new HashMap();
            if (this.goals != null) {
                Iterator i = this.goals.iterator();
                while (i.hasNext()) {
                    Goal g = (Goal)i.next();
                    this.goalMap.put(g.getId(), g);
                }
            }
        }
        return this.goalMap;
    }
}

