/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.profiles.Activation;
import org.apache.maven.profiles.ActivationProperty;
import org.apache.maven.profiles.AlwaysOnActivation;
import org.apache.maven.profiles.Profile;
import org.apache.maven.profiles.Repository;

public class ProfilesConversionUtils {
    private ProfilesConversionUtils() {
    }

    public static org.apache.maven.model.Profile convertFromProfileXmlProfile(Profile profileXmlProfile) {
        List pluginRepos;
        org.apache.maven.model.Profile profile = new org.apache.maven.model.Profile();
        profile.setId(profileXmlProfile.getId());
        profile.setSource("profiles.xml");
        Activation profileActivation = profileXmlProfile.getActivation();
        if (profileActivation != null) {
            org.apache.maven.model.Activation activation = new org.apache.maven.model.Activation();
            activation.setJdk(profileActivation.getJdk());
            ActivationProperty profileProp = profileActivation.getProperty();
            if (profileProp != null) {
                org.apache.maven.model.ActivationProperty prop = new org.apache.maven.model.ActivationProperty();
                prop.setName(profileProp.getName());
                prop.setValue(profileProp.getValue());
                activation.setProperty(prop);
            }
            profile.setActivation(activation);
        } else {
            profile.setActivation((org.apache.maven.model.Activation)new AlwaysOnActivation());
        }
        profile.setProperties(profileXmlProfile.getProperties());
        List repos = profileXmlProfile.getRepositories();
        if (repos != null) {
            Iterator it = repos.iterator();
            while (it.hasNext()) {
                profile.addRepository(ProfilesConversionUtils.convertFromProfileXmlRepository((Repository)it.next()));
            }
        }
        if ((pluginRepos = profileXmlProfile.getPluginRepositories()) != null) {
            Iterator it = pluginRepos.iterator();
            while (it.hasNext()) {
                profile.addPluginRepository(ProfilesConversionUtils.convertFromProfileXmlRepository((Repository)it.next()));
            }
        }
        return profile;
    }

    private static org.apache.maven.model.Repository convertFromProfileXmlRepository(Repository profileXmlRepo) {
        org.apache.maven.model.Repository repo = new org.apache.maven.model.Repository();
        repo.setId(profileXmlRepo.getId());
        repo.setLayout(profileXmlRepo.getLayout());
        repo.setName(profileXmlRepo.getName());
        repo.setSnapshotPolicy(profileXmlRepo.getSnapshotPolicy());
        repo.setChecksumPolicy(profileXmlRepo.getChecksumPolicy());
        repo.setUrl(profileXmlRepo.getUrl());
        return repo;
    }
}

