/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.Artifact;

public final class RelocatedArtifact
extends AbstractArtifact {
    private final Artifact artifact;
    private final String groupId;
    private final String artifactId;
    private final String classifier;
    private final String extension;
    private final String version;
    private final String message;

    public RelocatedArtifact(Artifact artifact, String groupId, String artifactId, String classifier, String extension, String version, String message) {
        this.artifact = Objects.requireNonNull(artifact, "artifact cannot be null");
        this.groupId = groupId != null && !groupId.isEmpty() ? groupId : null;
        this.artifactId = artifactId != null && !artifactId.isEmpty() ? artifactId : null;
        this.classifier = classifier != null && !classifier.isEmpty() ? classifier : null;
        this.extension = extension != null && !extension.isEmpty() ? extension : null;
        this.version = version != null && !version.isEmpty() ? version : null;
        this.message = message != null && !message.isEmpty() ? message : null;
    }

    public String getGroupId() {
        if (this.groupId != null) {
            return this.groupId;
        }
        return this.artifact.getGroupId();
    }

    public String getArtifactId() {
        if (this.artifactId != null) {
            return this.artifactId;
        }
        return this.artifact.getArtifactId();
    }

    public String getClassifier() {
        if (this.classifier != null) {
            return this.classifier;
        }
        return this.artifact.getClassifier();
    }

    public String getExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        return this.artifact.getExtension();
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return this.artifact.getVersion();
    }

    public Artifact setVersion(String version) {
        String current = this.getVersion();
        if (current.equals(version) || version == null && current.isEmpty()) {
            return this;
        }
        return new RelocatedArtifact(this.artifact, this.groupId, this.artifactId, this.classifier, this.extension, version, this.message);
    }

    @Deprecated
    public Artifact setFile(File file) {
        File current = this.getFile();
        if (Objects.equals(current, file)) {
            return this;
        }
        return new RelocatedArtifact(this.artifact.setFile(file), this.groupId, this.artifactId, this.classifier, this.extension, this.version, this.message);
    }

    public Artifact setPath(Path path) {
        Path current = this.getPath();
        if (Objects.equals(current, path)) {
            return this;
        }
        return new RelocatedArtifact(this.artifact.setPath(path), this.groupId, this.artifactId, this.classifier, this.extension, this.version, this.message);
    }

    public Artifact setProperties(Map<String, String> properties) {
        Map<String, String> current = this.getProperties();
        if (current.equals(properties) || properties == null && current.isEmpty()) {
            return this;
        }
        return new RelocatedArtifact(this.artifact.setProperties(properties), this.groupId, this.artifactId, this.classifier, this.extension, this.version, this.message);
    }

    @Deprecated
    public File getFile() {
        return this.artifact.getFile();
    }

    public Path getPath() {
        return this.artifact.getPath();
    }

    public String getProperty(String key, String defaultValue) {
        return this.artifact.getProperty(key, defaultValue);
    }

    public Map<String, String> getProperties() {
        return this.artifact.getProperties();
    }

    public String getMessage() {
        return this.message;
    }
}

