/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal.relocation;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.apache.maven.repository.internal.MavenArtifactRelocationSource;
import org.apache.maven.repository.internal.RelocatedArtifact;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.sisu.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="userProperties")
@Priority(value=50)
public final class UserPropertiesArtifactRelocationSource
implements MavenArtifactRelocationSource {
    public static final String NAME = "userProperties";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserPropertiesArtifactRelocationSource.class);
    private static final String CONFIG_PROP_RELOCATIONS_ENTRIES = "maven.relocations.entries";
    private static final Artifact SENTINEL = new DefaultArtifact("org.apache.maven.banned:user-relocation:1.0");

    @Override
    public Artifact relocatedTarget(RepositorySystemSession session, ArtifactDescriptorResult artifactDescriptorResult, Model model) throws ArtifactDescriptorException {
        Artifact original;
        Relocation relocation;
        Relocations relocations = (Relocations)session.getData().computeIfAbsent((Object)(this.getClass().getName() + ".relocations"), () -> this.parseRelocations(session));
        if (relocations != null && (relocation = relocations.getRelocation(original = artifactDescriptorResult.getRequest().getArtifact())) != null && (this.isProjectContext(artifactDescriptorResult.getRequest().getRequestContext()) || relocation.global)) {
            if (relocation.target == SENTINEL) {
                String message = "The artifact " + original + " has been banned from resolution: " + (relocation.global ? "User global ban" : "User project ban");
                LOGGER.debug(message);
                throw new ArtifactDescriptorException(artifactDescriptorResult, message);
            }
            RelocatedArtifact result = new RelocatedArtifact(original, UserPropertiesArtifactRelocationSource.isAny(relocation.target.getGroupId()) ? null : relocation.target.getGroupId(), UserPropertiesArtifactRelocationSource.isAny(relocation.target.getArtifactId()) ? null : relocation.target.getArtifactId(), UserPropertiesArtifactRelocationSource.isAny(relocation.target.getClassifier()) ? null : relocation.target.getClassifier(), UserPropertiesArtifactRelocationSource.isAny(relocation.target.getExtension()) ? null : relocation.target.getExtension(), UserPropertiesArtifactRelocationSource.isAny(relocation.target.getVersion()) ? null : relocation.target.getVersion(), relocation.global ? "User global relocation" : "User project relocation");
            LOGGER.debug("The artifact {} has been relocated to {}: {}", new Object[]{original, result, relocation.global ? "User global relocation" : "User project relocation"});
            return result;
        }
        return null;
    }

    private boolean isProjectContext(String context) {
        return context != null && context.startsWith("project");
    }

    private static boolean isAny(String str) {
        return "*".equals(str);
    }

    private static boolean matches(String pattern, String str) {
        if (UserPropertiesArtifactRelocationSource.isAny(pattern)) {
            return true;
        }
        if (pattern.endsWith("*")) {
            return str.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return Objects.equals(pattern, str);
    }

    private static Predicate<Artifact> artifactPredicate(Artifact artifact) {
        return a -> UserPropertiesArtifactRelocationSource.matches(artifact.getGroupId(), a.getGroupId()) && UserPropertiesArtifactRelocationSource.matches(artifact.getArtifactId(), a.getArtifactId()) && UserPropertiesArtifactRelocationSource.matches(artifact.getBaseVersion(), a.getBaseVersion()) && UserPropertiesArtifactRelocationSource.matches(artifact.getExtension(), a.getExtension()) && UserPropertiesArtifactRelocationSource.matches(artifact.getClassifier(), a.getClassifier());
    }

    private Relocations parseRelocations(RepositorySystemSession session) {
        String relocationsEntries = (String)session.getConfigProperties().get(CONFIG_PROP_RELOCATIONS_ENTRIES);
        if (relocationsEntries == null) {
            return null;
        }
        String[] entries = relocationsEntries.split(",");
        try (Stream<String> lines = Arrays.stream(entries);){
            List<Relocation> relocationList = lines.filter(l -> l != null && !l.trim().isEmpty()).map(l -> {
                String splitExpr;
                boolean global;
                if (l.contains(">>")) {
                    global = true;
                    splitExpr = ">>";
                } else if (l.contains(">")) {
                    global = false;
                    splitExpr = ">";
                } else {
                    throw new IllegalArgumentException("Unrecognized entry: " + l);
                }
                String[] parts = l.split(splitExpr);
                if (parts.length < 1) {
                    throw new IllegalArgumentException("Unrecognized entry: " + l);
                }
                Artifact s = UserPropertiesArtifactRelocationSource.parseArtifact(parts[0]);
                Artifact t = parts.length > 1 ? UserPropertiesArtifactRelocationSource.parseArtifact(parts[1]) : SENTINEL;
                return new Relocation(global, s, t);
            }).collect(Collectors.toList());
            LOGGER.info("Parsed {} user relocations", (Object)relocationList.size());
            Relocations relocations = new Relocations(relocationList);
            return relocations;
        }
    }

    private static Artifact parseArtifact(String coord) {
        String[] parts = coord.split(":");
        return switch (parts.length) {
            case 3 -> new DefaultArtifact(parts[0], parts[1], "*", "*", parts[2]);
            case 4 -> new DefaultArtifact(parts[0], parts[1], "*", parts[2], parts[3]);
            case 5 -> new DefaultArtifact(parts[0], parts[1], parts[2], parts[3], parts[4]);
            default -> throw new IllegalArgumentException("Bad artifact coordinates " + coord + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        };
    }

    private static class Relocations {
        private final List<Relocation> relocations;

        private Relocations(List<Relocation> relocations) {
            this.relocations = relocations;
        }

        private Relocation getRelocation(Artifact artifact) {
            return this.relocations.stream().filter(r -> r.predicate.test(artifact)).findFirst().orElse(null);
        }
    }

    private static class Relocation {
        private final Predicate<Artifact> predicate;
        private final boolean global;
        private final Artifact source;
        private final Artifact target;

        private Relocation(boolean global, Artifact source, Artifact target) {
            this.predicate = UserPropertiesArtifactRelocationSource.artifactPredicate(source);
            this.global = global;
            this.source = source;
            this.target = target;
        }

        public String toString() {
            return this.source + (this.global ? " >> " : " > ") + this.target;
        }
    }
}

