/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io.xpp3;

import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.TrackableBase;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class SettingsXpp3Reader {
    private boolean addDefaultEntities = true;

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    public boolean getBooleanValue(String s) {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    public char getCharacterValue(String s) {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public Date getDateValue(String s) {
        if (s != null) {
            DateFormat dateParser = DateFormat.getDateTimeInstance(0, 0);
            return dateParser.parse(s, new ParsePosition(0));
        }
        return null;
    }

    public double getDoubleValue(String s) {
        if (s != null) {
            return Double.valueOf(s);
        }
        return 0.0;
    }

    public float getFloatValue(String s) {
        if (s != null) {
            return Float.valueOf(s).floatValue();
        }
        return 0.0f;
    }

    public int getIntegerValue(String s) {
        if (s != null) {
            return Integer.valueOf(s);
        }
        return 0;
    }

    public long getLongValue(String s) {
        if (s != null) {
            return Long.valueOf(s);
        }
        return 0L;
    }

    public String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s == null) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    public short getShortValue(String s) {
        if (s != null) {
            return Short.valueOf(s);
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private Activation parseActivation(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Activation activation = new Activation();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("jdk")) {
                activation.setJdk(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("property")) {
                activation.setProperty(this.parseActivationProperty("property", parser));
                continue;
            }
            parser.nextText();
        }
        return activation;
    }

    private ActivationProperty parseActivationProperty(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        ActivationProperty activationProperty = new ActivationProperty();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("name")) {
                activationProperty.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("value")) {
                activationProperty.setValue(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            parser.nextText();
        }
        return activationProperty;
    }

    private IdentifiableBase parseIdentifiableBase(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        IdentifiableBase identifiableBase = new IdentifiableBase();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("id")) {
                identifiableBase.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            parser.nextText();
        }
        return identifiableBase;
    }

    private Mirror parseMirror(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Mirror mirror = new Mirror();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("mirrorOf")) {
                mirror.setMirrorOf(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                mirror.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                mirror.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("id")) {
                mirror.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            parser.nextText();
        }
        return mirror;
    }

    private Profile parseProfile(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Profile profile = new Profile();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("activation")) {
                profile.setActivation(this.parseActivation("activation", parser));
                continue;
            }
            if (parser.getName().equals("localRepository")) {
                profile.setLocalRepository(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("properties")) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    profile.addProperty(key, value);
                }
                continue;
            }
            if (parser.getName().equals("repositories")) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                profile.setRepositories(repositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("repository")) {
                        repositories.add(this.parseRepository("repository", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("pluginRepositories")) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                profile.setPluginRepositories(pluginRepositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("pluginRepository")) {
                        pluginRepositories.add(this.parseRepository("pluginRepository", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("id")) {
                profile.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            parser.nextText();
        }
        return profile;
    }

    private Proxy parseProxy(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Proxy proxy = new Proxy();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("active")) {
                proxy.setActive(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("protocol")) {
                proxy.setProtocol(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("username")) {
                proxy.setUsername(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("password")) {
                proxy.setPassword(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("port")) {
                proxy.setPort(this.getIntegerValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("host")) {
                proxy.setHost(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("nonProxyHosts")) {
                proxy.setNonProxyHosts(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("id")) {
                proxy.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            parser.nextText();
        }
        return proxy;
    }

    private Repository parseRepository(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Repository repository = new Repository();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("id")) {
                repository.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                repository.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                repository.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("snapshotPolicy")) {
                repository.setSnapshotPolicy(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("layout")) {
                repository.setLayout(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("checksumPolicy")) {
                repository.setChecksumPolicy(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            parser.nextText();
        }
        return repository;
    }

    private Server parseServer(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Server server = new Server();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("username")) {
                server.setUsername(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("password")) {
                server.setPassword(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("privateKey")) {
                server.setPrivateKey(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("passphrase")) {
                server.setPassphrase(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("id")) {
                server.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            parser.nextText();
        }
        return server;
    }

    private Settings parseSettings(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Settings settings = new Settings();
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2 && !parser.getName().equals(tagName)) {
                if (parser.getName().equals("localRepository")) {
                    settings.setLocalRepository(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("interactiveMode")) {
                    settings.setInteractiveMode(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                } else if (parser.getName().equals("offline")) {
                    settings.setOffline(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                } else if (parser.getName().equals("proxies")) {
                    ArrayList<Proxy> proxies = new ArrayList<Proxy>();
                    settings.setProxies(proxies);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("proxy")) {
                            proxies.add(this.parseProxy("proxy", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("servers")) {
                    ArrayList<Server> servers = new ArrayList<Server>();
                    settings.setServers(servers);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("server")) {
                            servers.add(this.parseServer("server", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("mirrors")) {
                    ArrayList<Mirror> mirrors = new ArrayList<Mirror>();
                    settings.setMirrors(mirrors);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("mirror")) {
                            mirrors.add(this.parseMirror("mirror", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("profiles")) {
                    ArrayList<Profile> profiles = new ArrayList<Profile>();
                    settings.setProfiles(profiles);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("profile")) {
                            profiles.add(this.parseProfile("profile", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("activeProfiles")) {
                    ArrayList<String> activeProfiles = new ArrayList<String>();
                    settings.setActiveProfiles(activeProfiles);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("activeProfile")) {
                            activeProfiles.add(this.getTrimmedValue(parser.nextText()));
                            continue;
                        }
                        parser.nextText();
                    }
                }
            }
            eventType = parser.next();
        }
        return settings;
    }

    private TrackableBase parseTrackableBase(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        TrackableBase trackableBase = new TrackableBase();
        while (parser.nextTag() == 2) {
            if (!parser.getName().equals(tagName)) continue;
        }
        return trackableBase;
    }

    public Settings read(Reader reader) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        if (this.addDefaultEntities) {
            parser.defineEntityReplacementText("nbsp", "\u00a0");
            parser.defineEntityReplacementText("iexcl", "\u00a1");
            parser.defineEntityReplacementText("cent", "\u00a2");
            parser.defineEntityReplacementText("pound", "\u00a3");
            parser.defineEntityReplacementText("curren", "\u00a4");
            parser.defineEntityReplacementText("yen", "\u00a5");
            parser.defineEntityReplacementText("brvbar", "\u00a6");
            parser.defineEntityReplacementText("sect", "\u00a7");
            parser.defineEntityReplacementText("uml", "\u00a8");
            parser.defineEntityReplacementText("copy", "\u00a9");
            parser.defineEntityReplacementText("ordf", "\u00aa");
            parser.defineEntityReplacementText("laquo", "\u00ab");
            parser.defineEntityReplacementText("not", "\u00ac");
            parser.defineEntityReplacementText("shy", "\u00ad");
            parser.defineEntityReplacementText("reg", "\u00ae");
            parser.defineEntityReplacementText("macr", "\u00af");
            parser.defineEntityReplacementText("deg", "\u00b0");
            parser.defineEntityReplacementText("plusmn", "\u00b1");
            parser.defineEntityReplacementText("sup2", "\u00b2");
            parser.defineEntityReplacementText("sup3", "\u00b3");
            parser.defineEntityReplacementText("acute", "\u00b4");
            parser.defineEntityReplacementText("micro", "\u00b5");
            parser.defineEntityReplacementText("para", "\u00b6");
            parser.defineEntityReplacementText("middot", "\u00b7");
            parser.defineEntityReplacementText("cedil", "\u00b8");
            parser.defineEntityReplacementText("sup1", "\u00b9");
            parser.defineEntityReplacementText("ordm", "\u00ba");
            parser.defineEntityReplacementText("raquo", "\u00bb");
            parser.defineEntityReplacementText("frac14", "\u00bc");
            parser.defineEntityReplacementText("frac12", "\u00bd");
            parser.defineEntityReplacementText("frac34", "\u00be");
            parser.defineEntityReplacementText("iquest", "\u00bf");
            parser.defineEntityReplacementText("Agrave", "\u00c0");
            parser.defineEntityReplacementText("Aacute", "\u00c1");
            parser.defineEntityReplacementText("Acirc", "\u00c2");
            parser.defineEntityReplacementText("Atilde", "\u00c3");
            parser.defineEntityReplacementText("Auml", "\u00c4");
            parser.defineEntityReplacementText("Aring", "\u00c5");
            parser.defineEntityReplacementText("AElig", "\u00c6");
            parser.defineEntityReplacementText("Ccedil", "\u00c7");
            parser.defineEntityReplacementText("Egrave", "\u00c8");
            parser.defineEntityReplacementText("Eacute", "\u00c9");
            parser.defineEntityReplacementText("Ecirc", "\u00ca");
            parser.defineEntityReplacementText("Euml", "\u00cb");
            parser.defineEntityReplacementText("Igrave", "\u00cc");
            parser.defineEntityReplacementText("Iacute", "\u00cd");
            parser.defineEntityReplacementText("Icirc", "\u00ce");
            parser.defineEntityReplacementText("Iuml", "\u00cf");
            parser.defineEntityReplacementText("ETH", "\u00d0");
            parser.defineEntityReplacementText("Ntilde", "\u00d1");
            parser.defineEntityReplacementText("Ograve", "\u00d2");
            parser.defineEntityReplacementText("Oacute", "\u00d3");
            parser.defineEntityReplacementText("Ocirc", "\u00d4");
            parser.defineEntityReplacementText("Otilde", "\u00d5");
            parser.defineEntityReplacementText("Ouml", "\u00d6");
            parser.defineEntityReplacementText("times", "\u00d7");
            parser.defineEntityReplacementText("Oslash", "\u00d8");
            parser.defineEntityReplacementText("Ugrave", "\u00d9");
            parser.defineEntityReplacementText("Uacute", "\u00da");
            parser.defineEntityReplacementText("Ucirc", "\u00db");
            parser.defineEntityReplacementText("Uuml", "\u00dc");
            parser.defineEntityReplacementText("Yacute", "\u00dd");
            parser.defineEntityReplacementText("THORN", "\u00de");
            parser.defineEntityReplacementText("szlig", "\u00df");
            parser.defineEntityReplacementText("agrave", "\u00e0");
            parser.defineEntityReplacementText("aacute", "\u00e1");
            parser.defineEntityReplacementText("acirc", "\u00e2");
            parser.defineEntityReplacementText("atilde", "\u00e3");
            parser.defineEntityReplacementText("auml", "\u00e4");
            parser.defineEntityReplacementText("aring", "\u00e5");
            parser.defineEntityReplacementText("aelig", "\u00e6");
            parser.defineEntityReplacementText("ccedil", "\u00e7");
            parser.defineEntityReplacementText("egrave", "\u00e8");
            parser.defineEntityReplacementText("eacute", "\u00e9");
            parser.defineEntityReplacementText("ecirc", "\u00ea");
            parser.defineEntityReplacementText("euml", "\u00eb");
            parser.defineEntityReplacementText("igrave", "\u00ec");
            parser.defineEntityReplacementText("iacute", "\u00ed");
            parser.defineEntityReplacementText("icirc", "\u00ee");
            parser.defineEntityReplacementText("iuml", "\u00ef");
            parser.defineEntityReplacementText("eth", "\u00f0");
            parser.defineEntityReplacementText("ntilde", "\u00f1");
            parser.defineEntityReplacementText("ograve", "\u00f2");
            parser.defineEntityReplacementText("oacute", "\u00f3");
            parser.defineEntityReplacementText("ocirc", "\u00f4");
            parser.defineEntityReplacementText("otilde", "\u00f5");
            parser.defineEntityReplacementText("ouml", "\u00f6");
            parser.defineEntityReplacementText("divide", "\u00f7");
            parser.defineEntityReplacementText("oslash", "\u00f8");
            parser.defineEntityReplacementText("ugrave", "\u00f9");
            parser.defineEntityReplacementText("uacute", "\u00fa");
            parser.defineEntityReplacementText("ucirc", "\u00fb");
            parser.defineEntityReplacementText("uuml", "\u00fc");
            parser.defineEntityReplacementText("yacute", "\u00fd");
            parser.defineEntityReplacementText("thorn", "\u00fe");
            parser.defineEntityReplacementText("yuml", "\u00ff");
            parser.defineEntityReplacementText("OElig", "\u0152");
            parser.defineEntityReplacementText("oelig", "\u0153");
            parser.defineEntityReplacementText("Scaron", "\u0160");
            parser.defineEntityReplacementText("scaron", "\u0161");
            parser.defineEntityReplacementText("Yuml", "\u0178");
            parser.defineEntityReplacementText("circ", "\u02c6");
            parser.defineEntityReplacementText("tilde", "\u02dc");
            parser.defineEntityReplacementText("ensp", "\u2002");
            parser.defineEntityReplacementText("emsp", "\u2003");
            parser.defineEntityReplacementText("thinsp", "\u2009");
            parser.defineEntityReplacementText("zwnj", "\u200c");
            parser.defineEntityReplacementText("zwj", "\u200d");
            parser.defineEntityReplacementText("lrm", "\u200e");
            parser.defineEntityReplacementText("rlm", "\u200f");
            parser.defineEntityReplacementText("ndash", "\u2013");
            parser.defineEntityReplacementText("mdash", "\u2014");
            parser.defineEntityReplacementText("lsquo", "\u2018");
            parser.defineEntityReplacementText("rsquo", "\u2019");
            parser.defineEntityReplacementText("sbquo", "\u201a");
            parser.defineEntityReplacementText("ldquo", "\u201c");
            parser.defineEntityReplacementText("rdquo", "\u201d");
            parser.defineEntityReplacementText("bdquo", "\u201e");
            parser.defineEntityReplacementText("dagger", "\u2020");
            parser.defineEntityReplacementText("Dagger", "\u2021");
            parser.defineEntityReplacementText("permil", "\u2030");
            parser.defineEntityReplacementText("lsaquo", "\u2039");
            parser.defineEntityReplacementText("rsaquo", "\u203a");
            parser.defineEntityReplacementText("euro", "\u20ac");
            parser.defineEntityReplacementText("fnof", "\u0192");
            parser.defineEntityReplacementText("Alpha", "\u0391");
            parser.defineEntityReplacementText("Beta", "\u0392");
            parser.defineEntityReplacementText("Gamma", "\u0393");
            parser.defineEntityReplacementText("Delta", "\u0394");
            parser.defineEntityReplacementText("Epsilon", "\u0395");
            parser.defineEntityReplacementText("Zeta", "\u0396");
            parser.defineEntityReplacementText("Eta", "\u0397");
            parser.defineEntityReplacementText("Theta", "\u0398");
            parser.defineEntityReplacementText("Iota", "\u0399");
            parser.defineEntityReplacementText("Kappa", "\u039a");
            parser.defineEntityReplacementText("Lambda", "\u039b");
            parser.defineEntityReplacementText("Mu", "\u039c");
            parser.defineEntityReplacementText("Nu", "\u039d");
            parser.defineEntityReplacementText("Xi", "\u039e");
            parser.defineEntityReplacementText("Omicron", "\u039f");
            parser.defineEntityReplacementText("Pi", "\u03a0");
            parser.defineEntityReplacementText("Rho", "\u03a1");
            parser.defineEntityReplacementText("Sigma", "\u03a3");
            parser.defineEntityReplacementText("Tau", "\u03a4");
            parser.defineEntityReplacementText("Upsilon", "\u03a5");
            parser.defineEntityReplacementText("Phi", "\u03a6");
            parser.defineEntityReplacementText("Chi", "\u03a7");
            parser.defineEntityReplacementText("Psi", "\u03a8");
            parser.defineEntityReplacementText("Omega", "\u03a9");
            parser.defineEntityReplacementText("alpha", "\u03b1");
            parser.defineEntityReplacementText("beta", "\u03b2");
            parser.defineEntityReplacementText("gamma", "\u03b3");
            parser.defineEntityReplacementText("delta", "\u03b4");
            parser.defineEntityReplacementText("epsilon", "\u03b5");
            parser.defineEntityReplacementText("zeta", "\u03b6");
            parser.defineEntityReplacementText("eta", "\u03b7");
            parser.defineEntityReplacementText("theta", "\u03b8");
            parser.defineEntityReplacementText("iota", "\u03b9");
            parser.defineEntityReplacementText("kappa", "\u03ba");
            parser.defineEntityReplacementText("lambda", "\u03bb");
            parser.defineEntityReplacementText("mu", "\u03bc");
            parser.defineEntityReplacementText("nu", "\u03bd");
            parser.defineEntityReplacementText("xi", "\u03be");
            parser.defineEntityReplacementText("omicron", "\u03bf");
            parser.defineEntityReplacementText("pi", "\u03c0");
            parser.defineEntityReplacementText("rho", "\u03c1");
            parser.defineEntityReplacementText("sigmaf", "\u03c2");
            parser.defineEntityReplacementText("sigma", "\u03c3");
            parser.defineEntityReplacementText("tau", "\u03c4");
            parser.defineEntityReplacementText("upsilon", "\u03c5");
            parser.defineEntityReplacementText("phi", "\u03c6");
            parser.defineEntityReplacementText("chi", "\u03c7");
            parser.defineEntityReplacementText("psi", "\u03c8");
            parser.defineEntityReplacementText("omega", "\u03c9");
            parser.defineEntityReplacementText("thetasym", "\u03d1");
            parser.defineEntityReplacementText("upsih", "\u03d2");
            parser.defineEntityReplacementText("piv", "\u03d6");
            parser.defineEntityReplacementText("bull", "\u2022");
            parser.defineEntityReplacementText("hellip", "\u2026");
            parser.defineEntityReplacementText("prime", "\u2032");
            parser.defineEntityReplacementText("Prime", "\u2033");
            parser.defineEntityReplacementText("oline", "\u203e");
            parser.defineEntityReplacementText("frasl", "\u2044");
            parser.defineEntityReplacementText("weierp", "\u2118");
            parser.defineEntityReplacementText("image", "\u2111");
            parser.defineEntityReplacementText("real", "\u211c");
            parser.defineEntityReplacementText("trade", "\u2122");
            parser.defineEntityReplacementText("alefsym", "\u2135");
            parser.defineEntityReplacementText("larr", "\u2190");
            parser.defineEntityReplacementText("uarr", "\u2191");
            parser.defineEntityReplacementText("rarr", "\u2192");
            parser.defineEntityReplacementText("darr", "\u2193");
            parser.defineEntityReplacementText("harr", "\u2194");
            parser.defineEntityReplacementText("crarr", "\u21b5");
            parser.defineEntityReplacementText("lArr", "\u21d0");
            parser.defineEntityReplacementText("uArr", "\u21d1");
            parser.defineEntityReplacementText("rArr", "\u21d2");
            parser.defineEntityReplacementText("dArr", "\u21d3");
            parser.defineEntityReplacementText("hArr", "\u21d4");
            parser.defineEntityReplacementText("forall", "\u2200");
            parser.defineEntityReplacementText("part", "\u2202");
            parser.defineEntityReplacementText("exist", "\u2203");
            parser.defineEntityReplacementText("empty", "\u2205");
            parser.defineEntityReplacementText("nabla", "\u2207");
            parser.defineEntityReplacementText("isin", "\u2208");
            parser.defineEntityReplacementText("notin", "\u2209");
            parser.defineEntityReplacementText("ni", "\u220b");
            parser.defineEntityReplacementText("prod", "\u220f");
            parser.defineEntityReplacementText("sum", "\u2211");
            parser.defineEntityReplacementText("minus", "\u2212");
            parser.defineEntityReplacementText("lowast", "\u2217");
            parser.defineEntityReplacementText("radic", "\u221a");
            parser.defineEntityReplacementText("prop", "\u221d");
            parser.defineEntityReplacementText("infin", "\u221e");
            parser.defineEntityReplacementText("ang", "\u2220");
            parser.defineEntityReplacementText("and", "\u2227");
            parser.defineEntityReplacementText("or", "\u2228");
            parser.defineEntityReplacementText("cap", "\u2229");
            parser.defineEntityReplacementText("cup", "\u222a");
            parser.defineEntityReplacementText("int", "\u222b");
            parser.defineEntityReplacementText("there4", "\u2234");
            parser.defineEntityReplacementText("sim", "\u223c");
            parser.defineEntityReplacementText("cong", "\u2245");
            parser.defineEntityReplacementText("asymp", "\u2248");
            parser.defineEntityReplacementText("ne", "\u2260");
            parser.defineEntityReplacementText("equiv", "\u2261");
            parser.defineEntityReplacementText("le", "\u2264");
            parser.defineEntityReplacementText("ge", "\u2265");
            parser.defineEntityReplacementText("sub", "\u2282");
            parser.defineEntityReplacementText("sup", "\u2283");
            parser.defineEntityReplacementText("nsub", "\u2284");
            parser.defineEntityReplacementText("sube", "\u2286");
            parser.defineEntityReplacementText("supe", "\u2287");
            parser.defineEntityReplacementText("oplus", "\u2295");
            parser.defineEntityReplacementText("otimes", "\u2297");
            parser.defineEntityReplacementText("perp", "\u22a5");
            parser.defineEntityReplacementText("sdot", "\u22c5");
            parser.defineEntityReplacementText("lceil", "\u2308");
            parser.defineEntityReplacementText("rceil", "\u2309");
            parser.defineEntityReplacementText("lfloor", "\u230a");
            parser.defineEntityReplacementText("rfloor", "\u230b");
            parser.defineEntityReplacementText("lang", "\u2329");
            parser.defineEntityReplacementText("rang", "\u232a");
            parser.defineEntityReplacementText("loz", "\u25ca");
            parser.defineEntityReplacementText("spades", "\u2660");
            parser.defineEntityReplacementText("clubs", "\u2663");
            parser.defineEntityReplacementText("hearts", "\u2665");
            parser.defineEntityReplacementText("diams", "\u2666");
        }
        return this.parseSettings("settings", (XmlPullParser)parser);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

