/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.artifact;

import java.io.File;
import java.io.InputStream;
import org.apache.maven.mercury.artifact.Artifact;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.artifact.ArtifactMetadata;

public class DefaultArtifact
extends ArtifactMetadata
implements Artifact {
    private File file;
    private InputStream stream;
    private String downloadUrl;
    private String inheritedScope;
    private byte[] pomBlob;

    public DefaultArtifact(String groupId, String artifactId, String version, String type, String classifier, boolean optional, String scope, String inheritedScope) {
        if (version == null) {
            throw new IllegalArgumentException("Version cannot be null.");
        }
        this.initialize(groupId, artifactId, version, type, classifier, optional, scope, inheritedScope);
    }

    public DefaultArtifact(ArtifactBasicMetadata bmd) {
        if (bmd.getVersion() == null) {
            throw new IllegalArgumentException("Version cannot be null.");
        }
        this.initialize(bmd.getGroupId(), bmd.getArtifactId(), bmd.getVersion(), bmd.getType(), bmd.getClassifier(), bmd.isOptional(), bmd.getScope(), bmd.getScope());
    }

    public String getInheritedScope() {
        return this.inheritedScope;
    }

    private void initialize(String groupId, String artifactId, String version, String type, String classifier, boolean optional, String scope, String inheritedScope) {
        this.inheritedScope = inheritedScope;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
        this.optional = optional;
        String desiredScope = Artifact.SCOPE_RUNTIME;
        boolean calc = true;
        if (inheritedScope == null) {
            desiredScope = scope;
        } else if (Artifact.SCOPE_TEST.equals(scope) || Artifact.SCOPE_PROVIDED.equals(scope)) {
            desiredScope = scope;
        } else if (Artifact.SCOPE_COMPILE.equals(scope) && Artifact.SCOPE_COMPILE.equals(inheritedScope)) {
            desiredScope = Artifact.SCOPE_COMPILE;
        }
        if (calc) {
            if (Artifact.SCOPE_TEST.equals(inheritedScope)) {
                desiredScope = Artifact.SCOPE_TEST;
            }
            if (Artifact.SCOPE_PROVIDED.equals(inheritedScope)) {
                desiredScope = Artifact.SCOPE_PROVIDED;
            }
            if (Artifact.SCOPE_SYSTEM.equals(scope)) {
                desiredScope = Artifact.SCOPE_SYSTEM;
            }
        }
        this.scope = desiredScope;
        this.validateIdentity();
    }

    private void validateIdentity() {
        if (this.empty(this.groupId)) {
            throw new IllegalArgumentException("The groupId cannot be empty.");
        }
        if (this.artifactId == null) {
            throw new IllegalArgumentException("The artifactId cannot be empty.");
        }
        if (this.type == null) {
            throw new IllegalArgumentException("The type cannot be empty.");
        }
        if (this.version == null) {
            throw new IllegalArgumentException("The version cannot be empty.");
        }
    }

    private boolean empty(String value) {
        return value == null || value.trim().length() < 1;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getId() {
        return this.getDependencyConflictId() + ":" + this.getVersion();
    }

    public String getDependencyConflictId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGroupId());
        sb.append(":");
        this.appendArtifactTypeClassifierString(sb);
        return sb.toString();
    }

    private void appendArtifactTypeClassifierString(StringBuilder sb) {
        sb.append(this.getArtifactId());
        sb.append(":");
        sb.append(this.getType());
        if (this.hasClassifier()) {
            sb.append(":");
            sb.append(this.getClassifier());
        }
    }

    public void setPomBlob(byte[] pomBlob) {
        this.pomBlob = pomBlob;
    }

    public byte[] getPomBlob() {
        return this.pomBlob;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getGroupId() != null) {
            sb.append(this.getGroupId());
            sb.append(":");
        }
        this.appendArtifactTypeClassifierString(sb);
        sb.append(":");
        if (this.getVersion() != null) {
            sb.append(this.getVersion());
        }
        if (this.scope != null) {
            sb.append(":");
            sb.append(this.scope);
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.groupId.hashCode();
        result = 37 * result + this.artifactId.hashCode();
        result = 37 * result + this.type.hashCode();
        if (this.version != null) {
            result = 37 * result + this.version.hashCode();
        }
        result = 37 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact a = (Artifact)o;
        if (!a.getGroupId().equals(this.groupId)) {
            return false;
        }
        if (!a.getArtifactId().equals(this.artifactId)) {
            return false;
        }
        if (!a.getVersion().equals(this.version)) {
            return false;
        }
        if (!a.getType().equals(this.type)) {
            return false;
        }
        return !(a.getClassifier() == null ? this.classifier != null : !a.getClassifier().equals(this.classifier));
    }

    public int compareTo(Artifact o) {
        Artifact a = o;
        int result = this.groupId.compareTo(a.getGroupId());
        if (result == 0 && (result = this.artifactId.compareTo(a.getArtifactId())) == 0 && (result = this.type.compareTo(a.getType())) == 0) {
            if (this.classifier == null) {
                if (a.getClassifier() != null) {
                    result = 1;
                }
            } else {
                result = a.getClassifier() != null ? this.classifier.compareTo(a.getClassifier()) : -1;
            }
            if (result == 0) {
                result = this.version.compareTo(a.getVersion());
            }
        }
        return result;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public void setResolvedVersion(String version) {
        this.version = version;
    }
}

