/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.local.m2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.mercury.artifact.Artifact;
import org.apache.maven.mercury.artifact.Quality;
import org.apache.maven.mercury.artifact.version.DefaultArtifactVersion;
import org.apache.maven.mercury.crypto.api.StreamObserverException;
import org.apache.maven.mercury.crypto.api.StreamVerifierFactory;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.repository.api.AbstractRepositoryWriter;
import org.apache.maven.mercury.repository.api.LocalRepository;
import org.apache.maven.mercury.repository.api.Repository;
import org.apache.maven.mercury.repository.api.RepositoryException;
import org.apache.maven.mercury.repository.api.RepositoryWriter;
import org.apache.maven.mercury.repository.local.m2.ArifactWriteData;
import org.apache.maven.mercury.repository.local.m2.ArtifactQueue;
import org.apache.maven.mercury.repository.metadata.AddVersionOperation;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataBuilder;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.repository.metadata.MetadataOperation;
import org.apache.maven.mercury.repository.metadata.SetSnapshotOperation;
import org.apache.maven.mercury.repository.metadata.Snapshot;
import org.apache.maven.mercury.repository.metadata.SnapshotOperand;
import org.apache.maven.mercury.repository.metadata.StringOperand;
import org.apache.maven.mercury.transport.api.Server;
import org.apache.maven.mercury.util.FileLockBundle;
import org.apache.maven.mercury.util.FileUtil;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRepositoryWriterM2
extends AbstractRepositoryWriter
implements RepositoryWriter {
    public static final String SYSTEM_PROPERTY_PARALLEL_WORKERS = "mercury.local.repo.workers";
    public static final int PARALLEL_WORKERS = Integer.parseInt(System.getProperty("mercury.local.repo.workers", "4"));
    public static final long SLEEP_FOR_WORKERS_TICK = 20L;
    public static final String SYSTEM_PROPERTY_SLEEP_FOR_LOCK = "mercury.local.lock.wait.millis";
    public static final long SLEEP_FOR_LOCK = Long.parseLong(System.getProperty("mercury.local.lock.wait.millis", "5000"));
    public static final long SLEEP_FOR_LOCK_TICK = 5L;
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(LocalRepositoryWriterM2.class);
    private static final Language _lang = new DefaultLanguage(LocalRepositoryWriterM2.class);
    private static final String[] _protocols = new String[]{"file"};
    private final LocalRepository _repo;
    private final File _repoDir;
    private final ArtifactQueue _aq;
    private static final ArifactWriteData LAST_ARTIFACT = new ArifactWriteData(null, null);

    public LocalRepositoryWriterM2(LocalRepository repo) {
        if (repo == null) {
            throw new IllegalArgumentException("localRepo cannot be null");
        }
        this._repoDir = repo.getDirectory();
        if (this._repoDir == null) {
            throw new IllegalArgumentException("localRepo directory cannot be null");
        }
        if (!this._repoDir.exists()) {
            throw new IllegalArgumentException("localRepo directory \"" + this._repoDir.getAbsolutePath() + "\" should exist");
        }
        this._repo = repo;
        this._aq = null;
    }

    private LocalRepositoryWriterM2(LocalRepository repo, File repoDir, ArtifactQueue aq) {
        this._repo = repo;
        this._repoDir = repoDir;
        this._aq = aq;
    }

    public Repository getRepository() {
        return this._repo;
    }

    public boolean canHandle(String protocol) {
        return "file".equals(protocol);
    }

    public String[] getProtocols() {
        return _protocols;
    }

    public void close() {
    }

    public void writeArtifacts(Collection<Artifact> artifacts) throws RepositoryException {
        if (artifacts == null || artifacts.size() < 1) {
            return;
        }
        int nWorkers = PARALLEL_WORKERS;
        if (artifacts.size() < nWorkers) {
            nWorkers = artifacts.size();
        }
        ArtifactQueue aq = new ArtifactQueue();
        LocalRepositoryWriterM2[] workers = new LocalRepositoryWriterM2[nWorkers];
        for (int i = 0; i < nWorkers; ++i) {
            workers[i] = new LocalRepositoryWriterM2(this._repo, this._repoDir, aq);
        }
        for (Artifact artifact : artifacts) {
            HashSet<StreamVerifierFactory> vFacs = null;
            Server server = this._repo.getServer();
            if (server != null && server.hasWriterStreamVerifierFactories()) {
                vFacs = server.getWriterStreamVerifierFactories();
            }
            if (vFacs == null) {
                vFacs = new HashSet<StreamVerifierFactory>(1);
            }
            aq.addArtifact(new ArifactWriteData(artifact, vFacs));
        }
        aq.addArtifact(LAST_ARTIFACT);
        for (int i = 0; i < nWorkers; ++i) {
            workers[i].start();
        }
        boolean alive = true;
        while (alive) {
            alive = false;
            for (int i = 0; i < nWorkers; ++i) {
                if (!workers[i].isAlive()) continue;
                alive = true;
                try {
                    LocalRepositoryWriterM2.sleep((long)20L);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
    }

    public void run() {
        try {
            ArifactWriteData awd;
            while ((awd = this._aq.getArtifact()) != null && awd.artifact != null) {
                this.writeArtifact(awd.artifact, awd.vFacs);
            }
        }
        catch (InterruptedException e) {
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeArtifact(Artifact artifact, Set<StreamVerifierFactory> vFacs) throws RepositoryException {
        DefaultArtifactVersion dav;
        Quality aq;
        InputStream in;
        boolean hasPomBlob;
        byte[] pomBlob;
        boolean isPom;
        block20: {
            if (artifact == null) {
                return;
            }
            isPom = "pom".equals(artifact.getType());
            pomBlob = artifact.getPomBlob();
            hasPomBlob = pomBlob != null && pomBlob.length > 0;
            in = artifact.getStream();
            if (in == null) {
                File aFile = artifact.getFile();
                if (aFile == null && !isPom) {
                    throw new RepositoryException(_lang.getMessage("artifact.no.stream", new String[]{artifact.toString()}));
                }
                try {
                    in = new FileInputStream(aFile);
                }
                catch (FileNotFoundException e) {
                    if (isPom) break block20;
                    throw new RepositoryException((Throwable)e);
                }
            }
        }
        boolean isSnapshot = (aq = (dav = new DefaultArtifactVersion(artifact.getVersion())).getQuality()).equals((Object)Quality.SNAPSHOT_QUALITY) || aq.equals((Object)Quality.SNAPSHOT_TS_QUALITY);
        String relGroupPath = artifact.getGroupId().replace('.', '/') + "/" + artifact.getArtifactId();
        String versionDirName = isSnapshot ? dav.getBase() + '-' + "SNAPSHOT" : artifact.getVersion();
        String relVersionPath = relGroupPath + '/' + versionDirName;
        String lockDir = null;
        FileLockBundle fLock = null;
        try {
            if (isPom) {
                if (in == null && !hasPomBlob) {
                    throw new RepositoryException(_lang.getMessage("pom.artifact.no.stream", new String[]{artifact.toString()}));
                }
                if (in != null) {
                    byte[] pomBlobBytes = FileUtil.readRawData((InputStream)in);
                    boolean bl = hasPomBlob = pomBlobBytes != null && pomBlobBytes.length > 0;
                    if (hasPomBlob) {
                        pomBlob = pomBlobBytes;
                    }
                }
            }
            lockDir = this._repoDir.getAbsolutePath() + '/' + relGroupPath;
            File gav = new File(lockDir);
            gav.mkdirs();
            fLock = FileUtil.lockDir((String)lockDir, (long)SLEEP_FOR_LOCK, (long)5L);
            if (fLock == null) {
                throw new RepositoryException(_lang.getMessage("cannot.lock.gav", new String[]{lockDir, "" + SLEEP_FOR_LOCK}));
            }
            String fName = this._repoDir.getAbsolutePath() + '/' + relVersionPath + '/' + artifact.getBaseName() + '.' + artifact.getType();
            if (!isPom) {
                FileUtil.writeAndSign((String)fName, (InputStream)in, vFacs);
                artifact.setFile(new File(fName));
            }
            File mdFile = new File(this._repoDir, relGroupPath + '/' + this._repo.getMetadataName());
            this.updateGAMetadata(mdFile, artifact, versionDirName, aq, vFacs);
            mdFile = new File(this._repoDir, relVersionPath + '/' + this._repo.getMetadataName());
            this.updateGAVMetadata(mdFile, artifact, aq, vFacs);
            if (artifact.hasClassifier()) {
                return;
            }
            if (hasPomBlob) {
                FileUtil.writeAndSign((String)(this._repoDir.getAbsolutePath() + '/' + relVersionPath + '/' + artifact.getArtifactId() + '-' + artifact.getVersion() + ".pom"), (byte[])pomBlob, vFacs);
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (fLock != null) {
                fLock.release();
            }
        }
    }

    private void updateGAMetadata(File mdFile, Artifact artifact, String version, Quality aq, Set<StreamVerifierFactory> vFacs) throws MetadataException, IOException, StreamObserverException {
        Metadata md = null;
        if (mdFile.exists()) {
            byte[] mdBytes = FileUtil.readRawData((File)mdFile);
            if (mdBytes == null) {
                throw new MetadataException(_lang.getMessage("file.is.empty", new String[]{mdFile.getAbsolutePath()}));
            }
            md = MetadataBuilder.read((InputStream)new ByteArrayInputStream(mdBytes));
        } else {
            md = new Metadata();
            md.setGroupId(artifact.getGroupId());
            md.setArtifactId(artifact.getArtifactId());
        }
        AddVersionOperation mdOp = new AddVersionOperation(new StringOperand(version));
        byte[] resBytes = MetadataBuilder.changeMetadata((Metadata)md, (MetadataOperation)mdOp);
        FileUtil.writeAndSign((String)mdFile.getAbsolutePath(), (byte[])resBytes, vFacs);
    }

    private void updateGAVMetadata(File mdFile, Artifact artifact, Quality aq, Set<StreamVerifierFactory> vFacs) throws MetadataException, IOException, StreamObserverException {
        Metadata md = null;
        if (mdFile.exists()) {
            byte[] mdBytes = FileUtil.readRawData((File)mdFile);
            md = MetadataBuilder.read((InputStream)new ByteArrayInputStream(mdBytes));
        } else {
            md = new Metadata();
            md.setGroupId(artifact.getGroupId());
            md.setArtifactId(artifact.getArtifactId());
            md.setVersion(artifact.getVersion());
        }
        ArrayList<Object> mdOps = new ArrayList<Object>(2);
        if (aq.equals((Object)Quality.SNAPSHOT_TS_QUALITY)) {
            Snapshot sn = MetadataBuilder.createSnapshot((String)artifact.getVersion());
            sn.setLocalCopy(true);
            mdOps.add(new SetSnapshotOperation(new SnapshotOperand(sn)));
        }
        mdOps.add(new AddVersionOperation(new StringOperand(artifact.getVersion())));
        byte[] resBytes = MetadataBuilder.changeMetadata((Metadata)md, mdOps);
        FileUtil.writeAndSign((String)mdFile.getAbsolutePath(), (byte[])resBytes, vFacs);
    }
}

