/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.transport.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;

public class Binding {
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(Binding.class);
    protected URL remoteResource;
    protected File localFile;
    protected ByteArrayOutputStream localOS;
    protected InputStream localIS;
    protected Exception error;

    public Binding() {
    }

    public Binding(URL remoteUrl, File localFile) {
        this.remoteResource = remoteUrl;
        this.localFile = localFile;
    }

    public Binding(URL remoteUrl) {
        this.remoteResource = remoteUrl;
        this.localOS = new ByteArrayOutputStream(4096);
    }

    public Binding(URL remoteUrl, InputStream is) {
        this.remoteResource = remoteUrl;
        this.localIS = is;
    }

    public Binding(URL remoteUrl, ByteArrayOutputStream os) {
        this.remoteResource = remoteUrl;
        this.localOS = os;
    }

    public URL getRemoteResource() {
        return this.remoteResource;
    }

    public void setRemoteResource(URL remoteResource) {
        this.remoteResource = remoteResource;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public boolean isInMemory() {
        return !this.isFile() && (this.localIS != null || this.localOS != null);
    }

    public boolean isFile() {
        return this.localFile != null;
    }

    public byte[] getInboundContent() {
        if (this.localOS != null) {
            return this.localOS.toByteArray();
        }
        return null;
    }

    public OutputStream getLocalOutputStream() {
        return this.localOS;
    }

    public InputStream getLocalInputStream() {
        return this.localIS;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public String toString() {
        return '[' + (this.remoteResource == null ? "null URL" : this.remoteResource.toString()) + " <=> " + (this.localFile == null ? (this.localIS == null ? (this.localOS == null ? "null local Res" : this.localOS) : "localIS") : this.localFile.getAbsolutePath()) + ']';
    }
}

