/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.transport.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.apache.maven.mercury.crypto.api.StreamObserverFactory;
import org.apache.maven.mercury.crypto.api.StreamVerifierFactory;
import org.apache.maven.mercury.transport.api.Credentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server {
    private String id;
    private URL url;
    private Credentials serverCredentials;
    private URL proxy;
    private Credentials proxyCredentials;
    private boolean requireEncryption = false;
    private boolean requireTrustedServer = false;
    private Set<StreamObserverFactory> writerStreamObserverFactories;
    private Set<StreamObserverFactory> readerStreamObserverFactories;
    private Set<StreamVerifierFactory> writerStreamVerifierFactories;
    private Set<StreamVerifierFactory> readerStreamVerifierFactories;
    private String userAgent;

    public Server(String id, URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL: " + url);
        }
        String ustr = url.toString();
        if (ustr.endsWith("/")) {
            try {
                this.url = new URL(ustr.substring(0, ustr.length() - 1));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            this.url = url;
        }
        this.id = id;
    }

    public Server(String id, URL url, boolean requireEncryption, boolean requireTrustedServer) {
        this(id, url);
        this.requireEncryption = requireEncryption;
        this.requireTrustedServer = requireTrustedServer;
    }

    public Server(String id, URL url, boolean requireEncryption, boolean requireTrustedServer, Credentials serverCredentials) {
        this(id, url, requireEncryption, requireTrustedServer);
        this.serverCredentials = serverCredentials;
    }

    public Server(String id, URL url, boolean requireEncryption, boolean requireTrustedServer, Credentials serverCredentials, URL proxy) {
        this(id, url, requireEncryption, requireTrustedServer, serverCredentials);
        this.proxy = proxy;
    }

    public Server(String id, URL url, boolean requireEncryption, boolean requireTrustedServer, Credentials serverCredentials, URL proxy, Credentials proxyCredentials) {
        this(id, url, requireEncryption, requireTrustedServer, serverCredentials, proxy);
        this.proxyCredentials = proxyCredentials;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasUserAgent() {
        return this.userAgent != null;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public Credentials getServerCredentials() {
        return this.serverCredentials;
    }

    public void setServerCredentials(Credentials cred) {
        this.serverCredentials = cred;
    }

    public URL getProxy() {
        return this.proxy;
    }

    public boolean hasProxy() {
        return this.proxy != null;
    }

    public void setProxy(URL proxy) {
        this.proxy = proxy;
    }

    public Credentials getProxyCredentials() {
        return this.proxyCredentials;
    }

    public void setProxyCredentials(Credentials user) {
        this.proxyCredentials = user;
    }

    public boolean hasWriterStreamVerifierFactories() {
        return this.writerStreamVerifierFactories != null && this.writerStreamVerifierFactories.size() > 0;
    }

    public Set<StreamVerifierFactory> getWriterStreamVerifierFactories() {
        return this.writerStreamVerifierFactories;
    }

    public void setWriterStreamVerifierFactories(Set<StreamVerifierFactory> factories) {
        this.writerStreamVerifierFactories = factories;
    }

    public boolean hasReaderStreamVerifierFactories() {
        return this.readerStreamVerifierFactories != null && this.readerStreamVerifierFactories.size() > 0;
    }

    public Set<StreamVerifierFactory> getReaderStreamVerifierFactories() {
        return this.readerStreamVerifierFactories;
    }

    public void setReaderStreamVerifierFactories(Set<StreamVerifierFactory> factories) {
        this.readerStreamVerifierFactories = factories;
    }

    public boolean hasWriterStreamObserverFactories() {
        return this.writerStreamObserverFactories != null && this.writerStreamObserverFactories.size() > 0;
    }

    public Set<StreamObserverFactory> getWriterStreamObserverFactories() {
        return this.writerStreamObserverFactories;
    }

    public void setWriterStreamObserverFactories(Set<StreamObserverFactory> factories) {
        this.writerStreamObserverFactories = factories;
    }

    public boolean hasReaderStreamObserverFactories() {
        return this.readerStreamObserverFactories != null && this.readerStreamObserverFactories.size() > 0;
    }

    public Set<StreamObserverFactory> getReaderStreamObserverFactories() {
        return this.readerStreamObserverFactories;
    }

    public void setReaderStreamObserverFactories(Set<StreamObserverFactory> factories) {
        this.readerStreamObserverFactories = factories;
    }

    public boolean isRequireEncryption() {
        return this.requireEncryption;
    }

    public boolean isRequireTrustedServer() {
        return this.requireTrustedServer;
    }

    public String toString() {
        return this.id + ": " + this.url;
    }
}

