/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    public static final TimeZone TS_TZ = TimeZone.getTimeZone("UTC");
    public static final DateFormat TS_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");

    public static String getUTCTimestamp() {
        return TimeUtil.getUTCTimestamp(new Date());
    }

    public static long getUTCTimestampAsLong() {
        return Long.parseLong(TimeUtil.getUTCTimestamp(new Date()));
    }

    public static long getUTCTimestampAsMillis() {
        return Long.parseLong(TimeUtil.getUTCTimestamp(new Date()));
    }

    public static String getUTCTimestamp(Date date) {
        return TS_FORMAT.format(date);
    }

    public static long toMillis(long ts) throws ParseException {
        return TimeUtil.toMillis("" + ts);
    }

    public static long toMillis(String ts) throws ParseException {
        Date dts = TS_FORMAT.parse(ts);
        return dts.getTime();
    }

    static {
        TS_FORMAT.setTimeZone(TS_TZ);
    }
}

