/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archiver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;

public class DirectoryArchiver
extends AbstractArchiver {
    public void createArchive() throws ArchiverException, IOException {
        String fileName;
        File destDirectory;
        Map listFiles = this.getFiles();
        if (listFiles == null || listFiles.size() == 0) {
            new ArchiverException("You must set at least one file.");
        }
        if ((destDirectory = this.getDestFile()) == null) {
            new ArchiverException("You must set the destination directory.");
        }
        if (destDirectory.exists() && !destDirectory.isDirectory()) {
            new ArchiverException(destDirectory + " isn't a directory.");
        }
        if (destDirectory.exists() && !destDirectory.canWrite()) {
            new ArchiverException(destDirectory + " is read-only.");
        }
        Iterator iter = this.getFiles().keySet().iterator();
        while (iter.hasNext()) {
            fileName = (String)iter.next();
            ArchiveEntry fileToAdd = (ArchiveEntry)this.getFiles().get(fileName);
            if (!destDirectory.equals(fileToAdd.getFile())) continue;
            throw new ArchiverException("The destination directory cannot include itself.");
        }
        this.getLogger().info("Building assembly directory : " + destDirectory.getAbsolutePath());
        try {
            iter = this.getFiles().keySet().iterator();
            while (iter.hasNext()) {
                fileName = (String)iter.next();
                ArchiveEntry f = (ArchiveEntry)this.getFiles().get(fileName);
                String destDir = destDirectory.getCanonicalPath();
                fileName = destDir + File.separator + fileName;
                this.copyFile(f, fileName);
            }
        }
        catch (IOException ioe) {
            String message = "Problem copying files : " + ioe.getMessage();
            throw new ArchiverException(message, (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(ArchiveEntry entry, String vPath) throws ArchiverException, IOException {
        if (vPath.length() <= 0) {
            return;
        }
        File inFile = entry.getFile();
        File outFile = new File(vPath);
        if (outFile.exists() && outFile.lastModified() >= inFile.lastModified()) {
            return;
        }
        outFile.setLastModified(inFile.lastModified());
        if (!inFile.isDirectory()) {
            if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                throw new ArchiverException("Unable to create directory or parent directory of " + outFile);
            }
            FileInputStream fIn = new FileInputStream(inFile);
            FileOutputStream fout = new FileOutputStream(outFile);
            try {
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    fout.write(buffer, 0, count);
                } while ((count = fIn.read(buffer, 0, buffer.length)) != -1);
            }
            finally {
                try {
                    fIn.close();
                }
                catch (IOException ioe) {
                    fout.close();
                    throw ioe;
                }
                fout.close();
            }
        }
        if (outFile.exists()) {
            if (!outFile.isDirectory()) {
                throw new ArchiverException("Expected directory and found file at copy destination of " + inFile + " to " + outFile);
            }
        } else if (!outFile.mkdirs()) {
            throw new ArchiverException("Unable to create directory or parent directory of " + outFile);
        }
    }
}

