/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.phase;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.AssemblyContext;
import org.apache.maven.plugin.assembly.DefaultAssemblyContext;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.archive.phase.wrappers.RepoBuilderConfigSourceWrapper;
import org.apache.maven.plugin.assembly.archive.phase.wrappers.RepoInfoWrapper;
import org.apache.maven.plugin.assembly.archive.task.AddDirectoryTask;
import org.apache.maven.plugin.assembly.artifact.DependencyResolver;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.repository.RepositoryAssembler;
import org.apache.maven.shared.repository.RepositoryAssemblyException;
import org.apache.maven.shared.repository.RepositoryBuilderConfigSource;
import org.apache.maven.shared.repository.model.RepositoryInfo;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class RepositoryAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase {
    private RepositoryAssembler repositoryAssembler;
    private DependencyResolver dependencyResolver;

    public RepositoryAssemblyPhase() {
    }

    public RepositoryAssemblyPhase(RepositoryAssembler repositoryAssembler, DependencyResolver resolver) {
        this.repositoryAssembler = repositoryAssembler;
        this.dependencyResolver = resolver;
    }

    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        this.execute(assembly, archiver, configSource, new DefaultAssemblyContext());
    }

    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource, AssemblyContext context) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        List repositoriesList = assembly.getRepositories();
        File tempRoot = configSource.getTemporaryRootDirectory();
        for (Repository repository : repositoriesList) {
            int fileMode;
            this.resolveDependencies(repository, configSource, context);
            String outputDirectory = AssemblyFormatUtils.getOutputDirectory(repository.getOutputDirectory(), configSource.getProject(), null, configSource.getFinalName(), configSource);
            File repositoryDirectory = new File(tempRoot, outputDirectory);
            if (!repositoryDirectory.exists()) {
                repositoryDirectory.mkdirs();
            }
            try {
                this.getLogger().debug("Assembling repository to: " + repositoryDirectory);
                this.repositoryAssembler.buildRemoteRepository(repositoryDirectory, this.wrap(repository), this.wrap(configSource));
                this.getLogger().debug("Finished assembling repository to: " + repositoryDirectory);
            }
            catch (RepositoryAssemblyException e) {
                throw new ArchiveCreationException("Failed to assemble repository: " + e.getMessage(), e);
            }
            AddDirectoryTask task = new AddDirectoryTask(repositoryDirectory);
            int dirMode = TypeConversionUtils.modeToInt(repository.getDirectoryMode(), this.getLogger());
            if (dirMode != -1) {
                task.setDirectoryMode(dirMode);
            }
            if ((fileMode = TypeConversionUtils.modeToInt(repository.getFileMode(), this.getLogger())) != -1) {
                task.setFileMode(fileMode);
            }
            task.setUseDefaultExcludes(repository.isUseDefaultExcludes());
            task.setOutputDirectory(outputDirectory);
            task.execute(archiver, configSource);
        }
    }

    private void resolveDependencies(Repository repository, AssemblerConfigurationSource configSource, AssemblyContext context) throws ArchiveCreationException {
        LinkedHashSet dependencyArtifacts;
        MavenProject project = configSource.getProject();
        ArtifactRepository localRepository = configSource.getLocalRepository();
        List additionalRemoteRepositories = configSource.getRemoteRepositories();
        try {
            dependencyArtifacts = this.dependencyResolver.resolveDependencies(project, repository.getScope(), context.getManagedVersionMap(), localRepository, additionalRemoteRepositories, true);
            if (dependencyArtifacts != null && !dependencyArtifacts.isEmpty()) {
                dependencyArtifacts = new LinkedHashSet(dependencyArtifacts);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new ArchiveCreationException("Failed to resolve dependencies for project: " + project.getId(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new ArchiveCreationException("Failed to resolve dependencies for project: " + project.getId(), e);
        }
        catch (InvalidDependencyVersionException e) {
            throw new ArchiveCreationException("Failed to resolve dependencies for project: " + project.getId(), e);
        }
        project.setDependencyArtifacts((Set)dependencyArtifacts);
    }

    private RepositoryBuilderConfigSource wrap(AssemblerConfigurationSource configSource) {
        return new RepoBuilderConfigSourceWrapper(configSource);
    }

    private RepositoryInfo wrap(Repository repository) {
        return new RepoInfoWrapper(repository);
    }
}

