/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.artifact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.ModuleSetAssemblyPhase;
import org.apache.maven.plugin.assembly.artifact.DependencyResolver;
import org.apache.maven.plugin.assembly.artifact.ResolutionManagementInfo;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.ModuleBinaries;
import org.apache.maven.plugin.assembly.model.ModuleSet;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.utils.FilterUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

public class DefaultDependencyResolver
extends AbstractLogEnabled
implements DependencyResolver {
    private ArtifactResolver resolver;
    private ArtifactMetadataSource metadataSource;
    private ArtifactFactory factory;
    private ArtifactCollector collector;

    public DefaultDependencyResolver() {
    }

    protected DefaultDependencyResolver(ArtifactResolver resolver, ArtifactMetadataSource metadataSource, ArtifactFactory factory, ArtifactCollector collector, Logger logger) {
        this.resolver = resolver;
        this.metadataSource = metadataSource;
        this.factory = factory;
        this.collector = collector;
        this.enableLogging(logger);
    }

    public Map buildManagedVersionMap(Assembly assembly, AssemblerConfigurationSource configSource) throws ArchiveCreationException, InvalidVersionSpecificationException, InvalidDependencyVersionException, ArtifactResolutionException {
        HashMap managedVersions;
        block10: {
            LinkedHashSet allRequiredArtifacts;
            block9: {
                MavenProject currentProject = configSource.getProject();
                ResolutionManagementInfo depInfo = new ResolutionManagementInfo(currentProject);
                this.getDependencySetResolutionRequirements(assembly.getDependencySets(), depInfo);
                this.getModuleSetResolutionRequirements(assembly.getModuleSets(), depInfo, configSource);
                this.getRepositoryResolutionRequirements(assembly.getRepositories(), depInfo);
                if (!depInfo.isResolutionRequired()) {
                    return new HashMap();
                }
                managedVersions = new HashMap();
                allRequiredArtifacts = new LinkedHashSet();
                List allRemoteRepos = new ArrayList();
                for (MavenProject project : depInfo.getEnabledProjects()) {
                    Map projectManagedVersions = this.getManagedVersionMap(project);
                    if (projectManagedVersions == null) continue;
                    for (String id : projectManagedVersions.keySet()) {
                        if (managedVersions.containsKey(id)) continue;
                        managedVersions.put(id, projectManagedVersions.get(id));
                    }
                }
                if (configSource.getRemoteRepositories() != null && !configSource.getRemoteRepositories().isEmpty()) {
                    allRemoteRepos.addAll(configSource.getRemoteRepositories());
                }
                for (MavenProject project : depInfo.getEnabledProjects()) {
                    allRequiredArtifacts.addAll(MavenMetadataSource.createArtifacts((ArtifactFactory)this.factory, (List)project.getDependencies(), null, (ArtifactFilter)depInfo.getScopeFilter(), (MavenProject)project));
                    allRemoteRepos = this.aggregateRemoteArtifactRepositories(allRemoteRepos, project);
                }
                if (!depInfo.isResolvedTransitively()) break block9;
                Artifact projectArtifact = this.factory.createBuildArtifact(currentProject.getGroupId(), currentProject.getArtifactId() + "-[assembly process]", currentProject.getVersion(), currentProject.getPackaging());
                List<DebugResolutionListener> listeners = this.getLogger().isDebugEnabled() ? Collections.singletonList(new DebugResolutionListener(this.getLogger())) : Collections.EMPTY_LIST;
                ArtifactResolutionResult resolutionResult = this.collector.collect(allRequiredArtifacts, projectArtifact, managedVersions, configSource.getLocalRepository(), allRemoteRepos, this.metadataSource, (ArtifactFilter)depInfo.getScopeFilter(), listeners);
                Set artifacts = resolutionResult.getArtifacts();
                if (artifacts == null) break block10;
                for (Artifact artifact : artifacts) {
                    String id = artifact.getDependencyConflictId();
                    if (managedVersions.containsKey(id)) continue;
                    managedVersions.put(id, artifact);
                }
                break block10;
            }
            if (allRequiredArtifacts != null) {
                for (Artifact artifact : allRequiredArtifacts) {
                    if (artifact.getVersion() == null) {
                        if (!this.getLogger().isDebugEnabled()) continue;
                        this.getLogger().debug("Not sure what to do with the version range: " + artifact.getVersionRange() + " in non-transitive mode, encountered while building managed versions collection; skipping it for now. Artifact: " + artifact);
                        continue;
                    }
                    String id = artifact.getDependencyConflictId();
                    if (managedVersions.containsKey(id)) continue;
                    managedVersions.put(id, artifact);
                }
            }
        }
        return managedVersions;
    }

    public Set resolveDependencies(MavenProject project, String scope, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, boolean resolveTransitively) throws InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        List repos = this.aggregateRemoteArtifactRepositories(remoteRepositories, project);
        ScopeArtifactFilter filter = new ScopeArtifactFilter(scope);
        Artifact artifact = this.factory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging());
        Set dependencyArtifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.factory, (List)project.getDependencies(), null, (ArtifactFilter)filter, (MavenProject)project);
        this.getLogger().debug("Dependencies for project: " + project.getId() + " are:\n" + StringUtils.join(dependencyArtifacts.iterator(), (String)"\n"));
        for (Artifact depArtifact : dependencyArtifacts) {
            if (!managedVersions.containsKey(depArtifact.getDependencyConflictId())) continue;
            this.manageArtifact(depArtifact, managedVersions);
        }
        if (resolveTransitively) {
            this.getLogger().debug("Resolving project dependencies transitively.");
            return this.resolveTransitively(dependencyArtifacts, artifact, managedVersions, localRepository, repos, (ArtifactFilter)filter, project);
        }
        this.getLogger().debug("Resolving project dependencies ONLY. Transitive dependencies WILL NOT be included in the results.");
        return this.resolveNonTransitively(dependencyArtifacts, artifact, managedVersions, localRepository, repos, (ArtifactFilter)filter);
    }

    protected Set resolveNonTransitively(Set dependencyArtifacts, Artifact artifact, Map managedVersions, ArtifactRepository localRepository, List repos, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        for (Artifact depArtifact : dependencyArtifacts) {
            this.resolver.resolve(depArtifact, repos, localRepository);
        }
        return dependencyArtifacts;
    }

    private Set resolveTransitively(Set dependencyArtifacts, Artifact artifact, Map managedVersions, ArtifactRepository localRepository, List repos, ArtifactFilter filter, MavenProject project) throws InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionResult result = this.resolver.resolveTransitively(dependencyArtifacts, artifact, managedVersions, localRepository, repos, this.metadataSource, filter);
        this.getLogger().debug("While resolving dependencies of " + project.getId() + ":");
        FilterUtils.reportFilteringStatistics(Collections.singleton(filter), this.getLogger());
        return result.getArtifacts();
    }

    protected void manageArtifact(Artifact targetArtifact, Map managedVersions) {
        Artifact artifact = (Artifact)managedVersions.get(targetArtifact.getDependencyConflictId());
        if (artifact == null) {
            return;
        }
        if (artifact.getVersion() != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Managing version for: " + targetArtifact.getDependencyConflictId() + " to: " + artifact.getVersion());
            }
            targetArtifact.setVersion(artifact.getVersion());
        }
        if (artifact.getScope() != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Managing scope for: " + targetArtifact.getDependencyConflictId() + " to: " + artifact.getScope());
            }
            targetArtifact.setScope(artifact.getScope());
        }
    }

    protected List aggregateRemoteArtifactRepositories(List remoteRepositories, MavenProject project) {
        ArrayList<List> repoLists = new ArrayList<List>();
        repoLists.add(remoteRepositories);
        repoLists.add(project.getRemoteArtifactRepositories());
        ArrayList<ArtifactRepository> remoteRepos = new ArrayList<ArtifactRepository>();
        HashSet<String> encounteredUrls = new HashSet<String>();
        for (List repositoryList : repoLists) {
            if (repositoryList == null || repositoryList.isEmpty()) continue;
            for (ArtifactRepository repo : repositoryList) {
                if (encounteredUrls.contains(repo.getUrl())) continue;
                remoteRepos.add(repo);
                encounteredUrls.add(repo.getUrl());
            }
        }
        return remoteRepos;
    }

    protected Map getManagedVersionMap(MavenProject project) throws InvalidVersionSpecificationException {
        List deps;
        DependencyManagement dependencyManagement = project.getModel().getDependencyManagement();
        HashMap<String, Artifact> map = null;
        if (dependencyManagement != null && (deps = dependencyManagement.getDependencies()) != null && deps.size() > 0) {
            map = new HashMap<String, Artifact>();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding managed dependencies for " + project.getId());
            }
            for (Dependency d : dependencyManagement.getDependencies()) {
                VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                Artifact artifact = this.factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("  " + artifact);
                }
                if (null != d.getExclusions() && !d.getExclusions().isEmpty()) {
                    ArrayList<String> exclusions = new ArrayList<String>();
                    for (Exclusion e : d.getExclusions()) {
                        exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
                    }
                    ExcludesArtifactFilter eaf = new ExcludesArtifactFilter(exclusions);
                    artifact.setDependencyFilter((ArtifactFilter)eaf);
                } else {
                    artifact.setDependencyFilter(null);
                }
                map.put(d.getManagementKey(), artifact);
            }
        } else if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    protected void getRepositoryResolutionRequirements(List repositories, ResolutionManagementInfo requirements) {
        if (repositories != null && !repositories.isEmpty()) {
            requirements.setResolutionRequired(true);
            for (Repository repo : repositories) {
                this.enableScope(repo.getScope(), requirements);
            }
        }
    }

    protected void getModuleSetResolutionRequirements(List moduleSets, ResolutionManagementInfo requirements, AssemblerConfigurationSource configSource) throws ArchiveCreationException {
        if (moduleSets != null && !moduleSets.isEmpty()) {
            for (ModuleSet set : moduleSets) {
                ModuleBinaries binaries = set.getBinaries();
                if (binaries == null) continue;
                Set projects = ModuleSetAssemblyPhase.getModuleProjects(set, configSource, this.getLogger());
                if (projects != null && !projects.isEmpty()) {
                    for (MavenProject p : projects) {
                        requirements.enableProjectResolution(p);
                    }
                }
                if (!binaries.isIncludeDependencies()) continue;
                this.getDependencySetResolutionRequirements(ModuleSetAssemblyPhase.getDependencySets(binaries), requirements);
            }
        }
    }

    protected void getDependencySetResolutionRequirements(List depSets, ResolutionManagementInfo requirements) {
        if (depSets != null && !depSets.isEmpty()) {
            requirements.setResolutionRequired(true);
            for (DependencySet set : depSets) {
                requirements.setResolvedTransitively(requirements.isResolvedTransitively() || set.isUseTransitiveDependencies());
                this.enableScope(set.getScope(), requirements);
            }
        }
    }

    private void enableScope(String scope, ResolutionManagementInfo requirements) {
        if ("compile".equals(scope)) {
            requirements.enableCompileScope();
        } else if ("provided".equals(scope)) {
            requirements.enableProvidedScope();
        } else if ("runtime".equals(scope)) {
            requirements.enableRuntimeScope();
        } else if ("system".equals(scope)) {
            requirements.enableSystemScope();
        } else if ("test".equals(scope)) {
            requirements.enableTestScope();
        }
    }

    protected ArtifactResolver getArtifactResolver() {
        return this.resolver;
    }

    protected DefaultDependencyResolver setArtifactResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    protected ArtifactMetadataSource getArtifactMetadataSource() {
        return this.metadataSource;
    }

    protected DefaultDependencyResolver setArtifactMetadataSource(ArtifactMetadataSource metadataSource) {
        this.metadataSource = metadataSource;
        return this;
    }

    protected ArtifactFactory getArtifactFactory() {
        return this.factory;
    }

    protected DefaultDependencyResolver setArtifactFactory(ArtifactFactory factory) {
        this.factory = factory;
        return this;
    }

    protected ArtifactCollector getArtifactCollector() {
        return this.collector;
    }

    protected DefaultDependencyResolver setArtifactCollector(ArtifactCollector collector) {
        this.collector = collector;
        return this;
    }

    protected DefaultDependencyResolver setLogger(Logger logger) {
        this.enableLogging(logger);
        return this;
    }
}

