/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.mojos;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.io.AssemblyReadException;
import org.apache.maven.plugin.assembly.io.AssemblyReader;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.mojos.AbstractAssemblyMojo;

public abstract class AbstractDirectoryMojo
extends AbstractAssemblyMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        List assemblies;
        AssemblyReader reader = this.getAssemblyReader();
        try {
            assemblies = reader.readAssemblies(this);
        }
        catch (AssemblyReadException e) {
            throw new MojoExecutionException("Error reading assembly descriptors: " + e.getMessage(), (Exception)e);
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoFailureException((Object)reader, e.getMessage(), "Mojo configuration is invalid: " + e.getMessage());
        }
        for (Assembly assembly : assemblies) {
            this.createDirectory(assembly);
        }
    }

    private void createDirectory(Assembly assembly) throws MojoExecutionException, MojoFailureException {
        AssemblyArchiver archiver = this.getAssemblyArchiver();
        String fullName = this.getFinalName();
        if (this.appendAssemblyId) {
            fullName = fullName + "-" + assembly.getId();
        } else if (this.getClassifier() != null) {
            fullName = fullName + "-" + this.getClassifier();
        }
        try {
            archiver.createArchive(assembly, fullName, "dir", this);
        }
        catch (ArchiveCreationException e) {
            throw new MojoExecutionException("Error creating assembly: " + e.getMessage(), (Exception)e);
        }
        catch (AssemblyFormattingException e) {
            throw new MojoExecutionException("Error creating assembly: " + e.getMessage(), (Exception)e);
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoFailureException((Object)assembly, "Assembly is incorrectly configured: " + assembly.getId(), "Assembly: " + assembly.getId() + " is not configured correctly: " + e.getMessage());
        }
    }
}

