/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.task;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.utils.AssemblyFormatUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;

public class AddDirectoryTask {
    private final File directory;
    private final InputStreamTransformer transformer;
    private List<String> includes;
    private List<String> excludes;
    private String outputDirectory;
    private boolean useDefaultExcludes = true;
    private int directoryMode = -1;
    private int fileMode = -1;

    public AddDirectoryTask(File directory, InputStreamTransformer transformers) {
        this.directory = directory;
        this.transformer = transformers;
    }

    public AddDirectoryTask(File directory) {
        this(directory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Archiver archiver) throws ArchiveCreationException {
        block16: {
            if (".".equals(this.outputDirectory)) {
                this.outputDirectory = "";
            } else if ("..".equals(this.outputDirectory)) {
                throw new ArchiveCreationException("Cannot add source directory: " + this.directory + " to archive-path: " + this.outputDirectory + ". All paths must be within the archive root directory.");
            }
            int oldDirMode = archiver.getOverrideDirectoryMode();
            int oldFileMode = archiver.getOverrideFileMode();
            boolean fileModeSet = false;
            boolean dirModeSet = false;
            try {
                if (this.directoryMode != -1) {
                    archiver.setDirectoryMode(this.directoryMode);
                    dirModeSet = true;
                }
                if (this.fileMode != -1) {
                    archiver.setFileMode(this.fileMode);
                    fileModeSet = true;
                }
                if (!this.directory.exists()) break block16;
                ArrayList<Object> directoryExcludes = this.excludes != null && !this.excludes.isEmpty() ? new ArrayList<String>(this.excludes) : new ArrayList();
                try {
                    String[] includesArray = null;
                    if (this.includes != null && !this.includes.isEmpty()) {
                        includesArray = new String[this.includes.size()];
                        int i = 0;
                        for (String string : this.includes) {
                            includesArray[i++] = this.normalize(string);
                        }
                    }
                    String[] excludesArray = new String[directoryExcludes.size()];
                    int i = 0;
                    for (String string : directoryExcludes) {
                        excludesArray[i++] = this.normalize(string);
                    }
                    DefaultFileSet defaultFileSet = new DefaultFileSet();
                    defaultFileSet.setUsingDefaultExcludes(this.useDefaultExcludes);
                    defaultFileSet.setPrefix(this.outputDirectory);
                    defaultFileSet.setDirectory(this.directory);
                    defaultFileSet.setIncludes(includesArray);
                    defaultFileSet.setExcludes(excludesArray);
                    if (this.transformer != null) {
                        defaultFileSet.setStreamTransformer(this.transformer);
                    }
                    archiver.addFileSet((FileSet)defaultFileSet);
                }
                catch (ArchiverException e) {
                    throw new ArchiveCreationException("Error adding directory to archive: " + e.getMessage(), e);
                }
            }
            finally {
                if (dirModeSet) {
                    archiver.setDirectoryMode(oldDirMode);
                }
                if (fileModeSet) {
                    archiver.setFileMode(oldFileMode);
                }
            }
        }
    }

    private String normalize(String include) {
        String value = AssemblyFormatUtils.fixRelativeRefs(include);
        if (value.startsWith("/") || value.startsWith("\\")) {
            value = value.substring(1);
        }
        return value;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setDirectoryMode(int directoryMode) {
        this.directoryMode = directoryMode;
    }

    public void setFileMode(int fileMode) {
        this.fileMode = fileMode;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }
}

