/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.CompilationFailureException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.manager.CompilerManager;
import org.codehaus.plexus.compiler.manager.NoSuchCompilerException;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCompilerMojo
extends AbstractMojo {
    private boolean debug;
    private boolean verbose;
    private boolean showDeprecation;
    private boolean optimize;
    private boolean showWarnings;
    private String source;
    private String target;
    private String encoding;
    private int staleMillis;
    private String compilerId;
    private String compilerVersion;
    private boolean fork;
    private String meminitial;
    private String maxmem;
    private String executable;
    private Map compilerArguments;
    private String compilerArgument;
    private String outputFileName;
    private File basedir;
    private File buildDirectory;
    private CompilerManager compilerManager;

    protected abstract SourceInclusionScanner getSourceInclusionScanner(int var1);

    protected abstract SourceInclusionScanner getSourceInclusionScanner(String var1);

    protected abstract List getClasspathElements();

    protected abstract List getCompileSourceRoots();

    protected abstract File getOutputDirectory();

    public void execute() throws MojoExecutionException, CompilationFailureException {
        CompilerError message;
        List messages;
        Set staleSources;
        Compiler compiler;
        this.getLog().debug((CharSequence)("Using compiler '" + this.compilerId + "'."));
        try {
            compiler = this.compilerManager.getCompiler(this.compilerId);
        }
        catch (NoSuchCompilerException e) {
            throw new MojoExecutionException("No such compiler '" + e.getCompilerId() + "'.");
        }
        List compileSourceRoots = AbstractCompilerMojo.removeEmptyCompileSourceRoots(this.getCompileSourceRoots());
        if (compileSourceRoots.isEmpty()) {
            this.getLog().info((CharSequence)"No sources to compile");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Source directories: " + compileSourceRoots.toString().replace(',', '\n')));
            this.getLog().debug((CharSequence)("Classpath: " + this.getClasspathElements().toString().replace(',', '\n')));
            this.getLog().debug((CharSequence)("Output directory: " + this.getOutputDirectory()));
        }
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setOutputLocation(this.getOutputDirectory().getAbsolutePath());
        compilerConfiguration.setClasspathEntries(this.getClasspathElements());
        compilerConfiguration.setSourceLocations(compileSourceRoots);
        compilerConfiguration.setOptimize(this.optimize);
        compilerConfiguration.setDebug(this.debug);
        compilerConfiguration.setVerbose(this.verbose);
        compilerConfiguration.setShowWarnings(this.showWarnings);
        compilerConfiguration.setShowDeprecation(this.showDeprecation);
        compilerConfiguration.setSourceVersion(this.source);
        compilerConfiguration.setTargetVersion(this.target);
        compilerConfiguration.setSourceEncoding(this.encoding);
        if (this.compilerArguments != null || this.compilerArgument != null) {
            LinkedHashMap<String, String> cplrArgsCopy = new LinkedHashMap<String, String>();
            if (this.compilerArguments != null) {
                Iterator i = this.compilerArguments.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry me = i.next();
                    String key = (String)me.getKey();
                    String value = (String)me.getValue();
                    if (!key.startsWith("-")) {
                        key = "-" + key;
                    }
                    cplrArgsCopy.put(key, value);
                }
            }
            if (!StringUtils.isEmpty((String)this.compilerArgument)) {
                cplrArgsCopy.put(this.compilerArgument, null);
            }
            compilerConfiguration.setCustomCompilerArguments(cplrArgsCopy);
        }
        compilerConfiguration.setFork(this.fork);
        if (this.fork) {
            String value;
            if (!StringUtils.isEmpty((String)this.meminitial)) {
                value = this.getMemoryValue(this.meminitial);
                if (value != null) {
                    compilerConfiguration.setMeminitial(value);
                } else {
                    this.getLog().info((CharSequence)("Invalid value for meminitial '" + this.meminitial + "'. Ignoring this option."));
                }
            }
            if (!StringUtils.isEmpty((String)this.maxmem)) {
                value = this.getMemoryValue(this.maxmem);
                if (value != null) {
                    compilerConfiguration.setMaxmem(value);
                } else {
                    this.getLog().info((CharSequence)("Invalid value for maxmem '" + this.maxmem + "'. Ignoring this option."));
                }
            }
        }
        compilerConfiguration.setExecutable(this.executable);
        compilerConfiguration.setWorkingDirectory(this.basedir);
        compilerConfiguration.setCompilerVersion(this.compilerVersion);
        compilerConfiguration.setBuildDirectory(this.buildDirectory);
        compilerConfiguration.setOutputFileName(this.outputFileName);
        try {
            staleSources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(this.staleMillis));
            boolean canUpdateTarget = compiler.canUpdateTarget(compilerConfiguration);
            if (compiler.getCompilerOutputStyle().equals((Object)CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) && !canUpdateTarget) {
                this.getLog().info((CharSequence)"RESCANNING!");
                String inputFileEnding = compiler.getInputFileEnding(compilerConfiguration);
                Set sources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(inputFileEnding));
                compilerConfiguration.setSourceFiles(sources);
            } else {
                compilerConfiguration.setSourceFiles(staleSources);
            }
        }
        catch (CompilerException e) {
            throw new MojoExecutionException("Error while computing stale sources.", (Exception)((Object)e));
        }
        if (staleSources.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Classpath:");
            Iterator it = this.getClasspathElements().iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                this.getLog().debug((CharSequence)(" " + s));
            }
            this.getLog().debug((CharSequence)"Source roots:");
            it = this.getCompileSourceRoots().iterator();
            while (it.hasNext()) {
                String root = (String)it.next();
                this.getLog().debug((CharSequence)(" " + root));
            }
            if (this.fork) {
                try {
                    String[] cl;
                    if (compilerConfiguration.getExecutable() != null) {
                        this.getLog().debug((CharSequence)"Excutable: ");
                        this.getLog().debug((CharSequence)(" " + compilerConfiguration.getExecutable()));
                    }
                    if ((cl = compiler.createCommandLine(compilerConfiguration)) != null && cl.length > 0) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(cl[0]);
                        for (int i = 1; i < cl.length; ++i) {
                            sb.append(" ");
                            sb.append(cl[i]);
                        }
                        this.getLog().debug((CharSequence)"Command line options:");
                        this.getLog().debug((CharSequence)sb);
                    }
                }
                catch (CompilerException ce) {
                    this.getLog().debug((Throwable)ce);
                }
            }
        }
        try {
            messages = compiler.compile(compilerConfiguration);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Fatal error compiling", e);
        }
        boolean compilationError = false;
        Iterator i = messages.iterator();
        while (i.hasNext()) {
            message = (CompilerError)i.next();
            if (!message.isError()) continue;
            compilationError = true;
        }
        if (compilationError) {
            throw new CompilationFailureException(messages);
        }
        i = messages.iterator();
        while (i.hasNext()) {
            message = (CompilerError)i.next();
            this.getLog().warn((CharSequence)message.toString());
        }
    }

    private String getMemoryValue(String setting) {
        String value = null;
        if (this.isDigits(setting)) {
            value = setting + "m";
        } else if (this.isDigits(setting.substring(0, setting.length() - 1)) && setting.toLowerCase().endsWith("m")) {
            value = setting;
        }
        return value;
    }

    private boolean isDigits(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private Set computeStaleSources(CompilerConfiguration compilerConfiguration, Compiler compiler, SourceInclusionScanner scanner) throws MojoExecutionException, CompilerException {
        File outputDirectory;
        SuffixMapping mapping;
        CompilerOutputStyle outputStyle = compiler.getCompilerOutputStyle();
        if (outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE) {
            mapping = new SuffixMapping(compiler.getInputFileEnding(compilerConfiguration), compiler.getOutputFileEnding(compilerConfiguration));
            outputDirectory = this.getOutputDirectory();
        } else if (outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) {
            mapping = new SingleTargetSourceMapping(compiler.getInputFileEnding(compilerConfiguration), compiler.getOutputFile(compilerConfiguration));
            outputDirectory = this.buildDirectory;
        } else {
            throw new MojoExecutionException("Unknown compiler output style: '" + outputStyle + "'.");
        }
        scanner.addSourceMapping((SourceMapping)mapping);
        HashSet staleSources = new HashSet();
        Iterator it = this.getCompileSourceRoots().iterator();
        while (it.hasNext()) {
            String sourceRoot = (String)it.next();
            File rootFile = new File(sourceRoot);
            if (!rootFile.isDirectory()) continue;
            try {
                staleSources.addAll(scanner.getIncludedSources(rootFile, outputDirectory));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + sourceRoot + "' " + "for stale files to recompile.", (Exception)((Object)e));
            }
        }
        return staleSources;
    }

    private static List removeEmptyCompileSourceRoots(List compileSourceRootsList) {
        ArrayList<String> newCompileSourceRootsList = new ArrayList<String>();
        if (compileSourceRootsList != null) {
            Iterator i = compileSourceRootsList.iterator();
            while (i.hasNext()) {
                String srcDir = (String)i.next();
                if (newCompileSourceRootsList.contains(srcDir) || !new File(srcDir).exists()) continue;
                newCompileSourceRootsList.add(srcDir);
            }
        }
        return newCompileSourceRootsList;
    }
}

