/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.resolvers;

import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.dependency.fromDependencies.AbstractDependencyFilterMojo;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;

public abstract class AbstractResolveMojo
extends AbstractDependencyFilterMojo {
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(property="outputFile")
    protected File outputFile;
    @Parameter(property="appendOutput", defaultValue="false")
    protected boolean appendOutput;
    @Parameter(property="excludeReactor", defaultValue="true")
    protected boolean excludeReactor;
    @Parameter
    protected boolean useJvmChmod = true;
    @Parameter
    protected boolean ignorePermissions;

    protected FilterArtifacts getPluginArtifactsFilter() {
        if (this.excludeReactor) {
            StringBuilder exAids = new StringBuilder();
            if (this.excludeArtifactIds != null) {
                exAids.append(this.excludeArtifactIds);
            }
            for (MavenProject rp : this.reactorProjects) {
                if (!"maven-plugin".equals(rp.getPackaging())) continue;
                if (exAids.length() > 0) {
                    exAids.append(",");
                }
                exAids.append(rp.getArtifactId());
            }
            this.excludeArtifactIds = exAids.toString();
        }
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ScopeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeScope), DependencyUtil.cleanToBeTokenizedString(this.excludeScope)));
        filter.addFilter((ArtifactsFilter)new TypeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeTypes), DependencyUtil.cleanToBeTokenizedString(this.excludeTypes)));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(DependencyUtil.cleanToBeTokenizedString(this.includeClassifiers), DependencyUtil.cleanToBeTokenizedString(this.excludeClassifiers)));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeGroupIds), DependencyUtil.cleanToBeTokenizedString(this.excludeGroupIds)));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeArtifactIds), DependencyUtil.cleanToBeTokenizedString(this.excludeArtifactIds)));
        return filter;
    }

    protected Set<Artifact> resolveDependencyArtifacts(MavenProject theProject) throws ArtifactResolverException, ArtifactNotFoundException, InvalidDependencyVersionException {
        Set artifacts = theProject.createArtifacts(this.getFactory(), "test", (ArtifactFilter)new ScopeArtifactFilter("test"));
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.getRemoteRepos());
        for (Artifact artifact : artifacts) {
            this.getArtifactResolver().resolveArtifact((ProjectBuildingRequest)buildingRequest, artifact);
        }
        return artifacts;
    }

    protected Set<Artifact> resolveArtifactDependencies(Artifact artifact) throws ArtifactResolverException, ArtifactNotFoundException, ProjectBuildingException, InvalidDependencyVersionException {
        Artifact pomArtifact = this.getFactory().createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        MavenProject pomProject = this.projectBuilder.build(pomArtifact, this.session.getProjectBuildingRequest()).getProject();
        return this.resolveDependencyArtifacts(pomProject);
    }
}

