/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.resolvers;

import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.resolvers.AbstractResolveMojo;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="resolve-plugins", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ResolvePluginsMojo
extends AbstractResolveMojo {
    @Parameter(defaultValue="${project.pluginArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remotePluginRepositories;
    @Parameter(property="excludeTransitive", defaultValue="false")
    private boolean excludeTransitive;

    @Override
    protected void doExecute() throws MojoExecutionException {
        FileWriter outputWriter = null;
        try {
            Set<Artifact> plugins = this.resolvePluginArtifacts();
            if (this.outputFile != null) {
                this.outputFile.getParentFile().mkdirs();
                outputWriter = new FileWriter(this.outputFile);
            }
            for (Artifact plugin : plugins) {
                String logStr = "Plugin Resolved: " + DependencyUtil.getFormattedFileName(plugin, false);
                if (!this.silent) {
                    this.getLog().info((CharSequence)logStr);
                }
                if (outputWriter != null) {
                    outputWriter.write(logStr);
                    outputWriter.write("\n");
                }
                if (this.excludeTransitive) continue;
                for (Artifact artifact : this.resolveArtifactDependencies(plugin)) {
                    logStr = "    Plugin Dependency Resolved: " + DependencyUtil.getFormattedFileName(artifact, false);
                    if (!this.silent) {
                        this.getLog().info((CharSequence)logStr);
                    }
                    if (outputWriter == null) continue;
                    outputWriter.write(logStr);
                    outputWriter.write("\n");
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Nested:", (Exception)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
        finally {
            IOUtil.close(outputWriter);
        }
    }

    protected Set<Artifact> resolvePluginArtifacts() throws ArtifactFilterException, ArtifactResolverException {
        Set plugins = this.getProject().getPluginArtifacts();
        Set reports = this.getProject().getReportArtifacts();
        HashSet<Artifact> artifacts = new HashSet();
        artifacts.addAll(reports);
        artifacts.addAll(plugins);
        FilterArtifacts filter = this.getPluginArtifactsFilter();
        artifacts = filter.filter(artifacts);
        for (Artifact artifact : new HashSet(artifacts)) {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setRemoteRepositories(this.remotePluginRepositories);
            this.getArtifactResolver().resolveArtifact((ProjectBuildingRequest)buildingRequest, artifact);
        }
        return artifacts;
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }
}

