/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.AbstractEarMojo;
import org.apache.maven.plugin.ear.EarModule;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class EarMojo
extends AbstractEarMojo {
    private File earSourceDirectory;
    private String earSourceIncludes = "**";
    private String earSourceExcludes;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private File manifestFile;
    private String applicationXml;
    private String outputDirectory;
    private String finalName;
    private File resourcesDir;
    private JarArchiver jarArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.getLog().debug((CharSequence)" ======= EarMojo settings =======");
        this.getLog().debug((CharSequence)("earSourceDirectory[" + this.earSourceDirectory + "]"));
        this.getLog().debug((CharSequence)("manifestLocation[" + this.manifestFile + "]"));
        this.getLog().debug((CharSequence)("applicationXml[" + this.getApplicationXml() + "]"));
        this.getLog().debug((CharSequence)("workDirectory[" + this.getWorkDirectory() + "]"));
        this.getLog().debug((CharSequence)("outputDirectory[" + this.outputDirectory + "]"));
        this.getLog().debug((CharSequence)("finalName[" + this.finalName + "]"));
        try {
            Iterator iter = this.getModules().iterator();
            while (iter.hasNext()) {
                EarModule module = (EarModule)iter.next();
                this.getLog().info((CharSequence)("Copying artifact[" + module + "] to[" + module.getUri() + "]"));
                File destinationFile = EarMojo.buildDestinationFile(this.getWorkDirectory(), module.getUri());
                File sourceFile = module.getArtifact().getFile();
                if (!sourceFile.isFile()) {
                    throw new MojoExecutionException("Cannot copy a directory: " + sourceFile.getAbsolutePath() + "; Did you package/install " + module.getArtifact() + "?");
                }
                FileUtils.copyFile((File)module.getArtifact().getFile(), (File)destinationFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR modules", (Exception)e);
        }
        try {
            File earSourceDir = this.earSourceDirectory;
            if (earSourceDir.exists()) {
                this.getLog().info((CharSequence)("Copy ear sources to " + this.getWorkDirectory().getAbsolutePath()));
                String[] fileNames = this.getEarFiles(earSourceDir);
                for (int i = 0; i < fileNames.length; ++i) {
                    FileUtils.copyFile((File)new File(earSourceDir, fileNames[i]), (File)new File(this.getWorkDirectory(), fileNames[i]));
                }
            }
            if (this.applicationXml != null && !"".equals(this.applicationXml)) {
                this.getLog().info((CharSequence)("Including custom application.xml[" + this.applicationXml + "]"));
                File metaInfDir = new File(this.getWorkDirectory(), "META-INF");
                FileUtils.copyFile((File)new File(this.applicationXml), (File)new File(metaInfDir, "/application.xml"));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR sources", (Exception)e);
        }
        try {
            if (this.resourcesDir.exists()) {
                this.getLog().info((CharSequence)("Copy ear resources to " + this.getWorkDirectory().getAbsolutePath()));
                String[] fileNames = this.getEarFiles(this.resourcesDir);
                for (int i = 0; i < fileNames.length; ++i) {
                    FileUtils.copyFile((File)new File(this.resourcesDir, fileNames[i]), (File)new File(this.getWorkDirectory(), fileNames[i]));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR resources", (Exception)e);
        }
        File ddFile = new File(this.getWorkDirectory(), "META-INF/application.xml");
        if (!ddFile.exists()) {
            throw new MojoExecutionException("Deployment descriptor: " + ddFile.getAbsolutePath() + " does not exist.");
        }
        try {
            File earFile = new File(this.outputDirectory, this.finalName + ".ear");
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(earFile);
            this.includeCustomManifestFile();
            archiver.getArchiver().addDirectory(this.getWorkDirectory());
            archiver.createArchive(this.getProject(), this.archive);
            this.project.getArtifact().setFile(earFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling EAR", e);
        }
    }

    public String getApplicationXml() {
        return this.applicationXml;
    }

    public void setApplicationXml(String applicationXml) {
        this.applicationXml = applicationXml;
    }

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>(FileUtils.getDefaultExcludesAsList());
        if (this.earSourceExcludes != null && !"".equals(this.earSourceExcludes)) {
            excludeList.add(this.earSourceExcludes);
        }
        if (this.getApplicationXml() != null && !"".equals(this.getApplicationXml())) {
            excludeList.add("**/META-INF/application.xml");
        }
        return excludeList.toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] getIncludes() {
        return new String[]{this.earSourceIncludes};
    }

    private static File buildDestinationFile(File buildDir, String uri) {
        return new File(buildDir, uri);
    }

    private void includeCustomManifestFile() {
        File customManifestFile = this.manifestFile;
        if (!customManifestFile.exists()) {
            this.getLog().info((CharSequence)("Could not find manifest file: " + this.manifestFile + " - Generating one"));
        } else {
            this.getLog().info((CharSequence)("Including custom manifest file[" + customManifestFile + "]"));
            this.archive.setManifestFile(customManifestFile);
        }
    }

    private String[] getEarFiles(File sourceDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

