/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.EarExecutionContext;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.plugin.ear.util.ArtifactRepository;
import org.codehaus.plexus.util.xml.XMLWriter;

public abstract class AbstractEarModule
implements EarModule {
    protected static final String MODULE_ELEMENT = "module";
    protected static final String JAVA_MODULE = "java";
    protected static final String ALT_DD = "alt-dd";
    private Artifact artifact;
    private String groupId;
    private String artifactId;
    private String classifier;
    protected String bundleDir;
    protected String bundleFileName;
    protected Boolean excluded = Boolean.FALSE;
    private String uri;
    protected Boolean unpack = null;
    protected String altDeploymentDescriptor;
    private String moduleId;
    protected EarExecutionContext earExecutionContext;

    public AbstractEarModule() {
    }

    public AbstractEarModule(Artifact a) {
        this.artifact = a;
        this.groupId = a.getGroupId();
        this.artifactId = a.getArtifactId();
        this.classifier = a.getClassifier();
        this.bundleDir = null;
    }

    public void setEarExecutionContext(EarExecutionContext earExecutionContext) {
        this.earExecutionContext = earExecutionContext;
    }

    public void resolveArtifact(Set artifacts) throws EarPluginException, MojoFailureException {
        if (this.artifact == null) {
            if (this.groupId == null || this.artifactId == null) {
                throw new MojoFailureException("Could not resolve artifact[" + this.groupId + ":" + this.artifactId + ":" + this.getType() + "]");
            }
            ArtifactRepository ar = this.earExecutionContext.getArtifactRepository();
            this.artifact = ar.getUniqueArtifact(this.groupId, this.artifactId, this.getType(), this.classifier);
            if (this.artifact == null) {
                Set candidates = ar.getArtifacts(this.groupId, this.artifactId, this.getType());
                if (candidates.size() > 1) {
                    throw new MojoFailureException("Artifact[" + this + "] has " + candidates.size() + " candidates, please provide a classifier.");
                }
                throw new MojoFailureException("Artifact[" + this + "] is not a dependency of the project.");
            }
        }
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getUri() {
        if (this.uri == null) {
            this.uri = this.getBundleDir() == null ? this.getBundleFileName() : this.getBundleDir() + this.getBundleFileName();
        }
        return this.uri;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getBundleDir() {
        if (this.bundleDir != null) {
            this.bundleDir = AbstractEarModule.cleanBundleDir(this.bundleDir);
        }
        return this.bundleDir;
    }

    public String getBundleFileName() {
        if (this.bundleFileName == null) {
            this.bundleFileName = this.earExecutionContext.getFileNameMapping().mapFileName(this.artifact);
        }
        return this.bundleFileName;
    }

    public String getAltDeploymentDescriptor() {
        return this.altDeploymentDescriptor;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public Boolean shouldUnpack() {
        return this.unpack;
    }

    protected void writeAltDeploymentDescriptor(XMLWriter writer, String version) {
        if (this.getAltDeploymentDescriptor() != null) {
            writer.startElement(ALT_DD);
            writer.writeText(this.getAltDeploymentDescriptor());
            writer.endElement();
        }
    }

    protected void startModuleElement(XMLWriter writer, Boolean generateId) {
        writer.startElement(MODULE_ELEMENT);
        if (this.getModuleId() != null) {
            writer.addAttribute("id", this.getModuleId());
        } else if (generateId.booleanValue()) {
            Artifact artifact = this.getArtifact();
            String generatedId = artifact.getType().toUpperCase() + "_" + artifact.getGroupId() + "." + artifact.getArtifactId();
            if (null != artifact.getClassifier() && artifact.getClassifier().trim().length() > 0) {
                generatedId = generatedId + "-" + artifact.getClassifier().trim();
            }
            writer.addAttribute("id", generatedId);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getType()).append(":").append(this.groupId).append(":").append(this.artifactId);
        if (this.classifier != null) {
            sb.append(":").append(this.classifier);
        }
        if (this.artifact != null) {
            sb.append(":").append(this.artifact.getVersion());
        }
        return sb.toString();
    }

    static String cleanBundleDir(String bundleDir) {
        if (bundleDir == null) {
            return bundleDir;
        }
        if ((bundleDir = bundleDir.replace('\\', '/')).startsWith("/")) {
            bundleDir = bundleDir.substring(1, bundleDir.length());
        }
        if (bundleDir.length() > 0 && !bundleDir.endsWith("/")) {
            bundleDir = bundleDir + "/";
        }
        return bundleDir;
    }

    static boolean areNullOrEqual(Object first, Object second) {
        if (first != null) {
            return first.equals(second);
        }
        return second == null;
    }

    void setUri(String uri) {
        this.uri = uri;
    }
}

