/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ear;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.ear.AbstractEarMojo;
import org.apache.maven.plugins.ear.EarModule;
import org.apache.maven.plugins.ear.EarModuleFactory;
import org.apache.maven.plugins.ear.JarModule;
import org.apache.maven.plugins.ear.util.EarMavenArchiver;
import org.apache.maven.plugins.ear.util.JavaEEVersion;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.AbstractMavenFilteringRequest;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.ear.EarArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="ear", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class EarMojo
extends AbstractEarMojo {
    @Parameter(defaultValue="${basedir}/src/main/application", required=true)
    private File earSourceDirectory;
    @Parameter(alias="includes", defaultValue="**")
    private String earSourceIncludes;
    @Parameter(alias="excludes")
    private String earSourceExcludes;
    @Parameter(defaultValue="false")
    private boolean filtering;
    @Parameter
    private List<String> filters;
    @Parameter
    private List<String> nonFilteredFileExtensions;
    @Parameter(defaultValue="false")
    private boolean escapedBackslashesInFilePath;
    @Parameter
    protected String escapeString;
    @Parameter(defaultValue="false")
    private boolean skipClassPathModification;
    @Parameter
    private String applicationXml;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true, readonly=true)
    private String finalName;
    @Parameter
    private String unpackTypes;
    @Parameter
    private String classifier;
    @Parameter
    private String packagingExcludes;
    @Parameter
    private String packagingIncludes;
    @Parameter(defaultValue="false")
    private boolean skinnyWars;
    @Component(role=Archiver.class, hint="ear")
    private EarArchiver earArchiver;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Component(role=Archiver.class, hint="zip")
    private ZipArchiver zipArchiver;
    @Component(role=UnArchiver.class, hint="zip")
    private ZipUnArchiver zipUnArchiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private ArchiverManager archiverManager;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    private MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    private List<FileUtils.FilterWrapper> filterWrappers;
    @Parameter(defaultValue="true")
    private boolean useJvmChmod = true;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        JarArchiver theArchiver;
        super.execute();
        File earFile = EarMojo.getEarFile(this.outputDirectory, this.finalName, this.classifier);
        EarMavenArchiver archiver = new EarMavenArchiver(this.getModules());
        File ddFile = new File(this.getWorkDirectory(), "META-INF/application.xml");
        if (ddFile.exists()) {
            this.earArchiver.setAppxml(ddFile);
            theArchiver = this.earArchiver;
        } else {
            theArchiver = this.jarArchiver;
        }
        this.getLog().debug((CharSequence)("Ear archiver implementation [" + theArchiver.getClass().getName() + "]"));
        archiver.setArchiver(theArchiver);
        archiver.setOutputFile(earFile);
        archiver.setCreatedBy("Maven EAR Plugin", "org.apache.maven.plugins", "maven-ear-plugin");
        Date reproducibleLastModifiedDate = archiver.configureReproducible(this.outputTimestamp);
        this.zipArchiver.setUseJvmChmod(this.useJvmChmod);
        if (reproducibleLastModifiedDate != null) {
            this.zipArchiver.configureReproducible(reproducibleLastModifiedDate);
        }
        this.zipUnArchiver.setUseJvmChmod(this.useJvmChmod);
        JavaEEVersion javaEEVersion = JavaEEVersion.getJavaEEVersion(this.version);
        Collection<String> outdatedResources = this.initOutdatedResources();
        List<String> unpackTypesList = this.createUnpackList();
        this.copyModules(javaEEVersion, unpackTypesList, outdatedResources);
        try {
            File earSourceDir = this.earSourceDirectory;
            if (earSourceDir.exists()) {
                String[] fileNames;
                this.getLog().info((CharSequence)("Copy ear sources to " + this.getWorkDirectory().getAbsolutePath()));
                for (String fileName : fileNames = this.getEarFiles(earSourceDir)) {
                    this.copyFile(new File(earSourceDir, fileName), new File(this.getWorkDirectory(), fileName));
                    outdatedResources.remove(Paths.get(fileName, new String[0]).toString());
                }
            }
            if (this.applicationXml != null && !"".equals(this.applicationXml)) {
                this.getLog().info((CharSequence)("Including custom application.xml[" + this.applicationXml + "]"));
                File metaInfDir = new File(this.getWorkDirectory(), "META-INF");
                this.copyFile(new File(this.applicationXml), new File(metaInfDir, "/application.xml"));
                outdatedResources.remove(Paths.get("META-INF/application.xml", new String[0]).toString());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR sources", (Exception)e);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Error filtering EAR sources", (Exception)((Object)e));
        }
        if (!ddFile.exists() && javaEEVersion.lt(JavaEEVersion.FIVE)) {
            throw new MojoExecutionException("Deployment descriptor: " + ddFile.getAbsolutePath() + " does not exist.");
        }
        outdatedResources.remove(Paths.get("META-INF/application.xml", new String[0]).toString());
        if (this.getJbossConfiguration() != null) {
            outdatedResources.remove(Paths.get("META-INF/jboss-app.xml", new String[0]).toString());
        }
        this.deleteOutdatedResources(outdatedResources);
        try {
            this.getLog().debug((CharSequence)("Excluding " + Arrays.asList(this.getPackagingExcludes()) + " from the generated EAR."));
            this.getLog().debug((CharSequence)("Including " + Arrays.asList(this.getPackagingIncludes()) + " in the generated EAR."));
            archiver.getArchiver().addDirectory(this.getWorkDirectory(), this.getPackagingIncludes(), this.getPackagingExcludes());
            archiver.createArchive(this.session, this.getProject(), this.archive);
        }
        catch (IOException | DependencyResolutionRequiredException | ManifestException e) {
            throw new MojoExecutionException("Error assembling EAR", (Exception)e);
        }
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), "ear", this.classifier, earFile);
        } else {
            this.getProject().getArtifact().setFile(earFile);
        }
    }

    private void copyModules(JavaEEVersion javaEEVersion, List<String> unpackTypesList, Collection<String> outdatedResources) throws MojoExecutionException, MojoFailureException {
        Path workingDir = this.getWorkDirectory().toPath();
        try {
            for (EarModule module : this.getModules()) {
                File sourceFile = module.getArtifact().getFile();
                File destinationFile = EarMojo.buildDestinationFile(this.getWorkDirectory(), module.getUri());
                if (!sourceFile.isFile()) {
                    throw new MojoExecutionException("Cannot copy a directory: " + sourceFile.getAbsolutePath() + "; Did you package/install " + module.getArtifact() + "?");
                }
                if (destinationFile.getCanonicalPath().equals(sourceFile.getCanonicalPath())) {
                    this.getLog().info((CharSequence)("Skipping artifact [" + module + "], as it already exists at [" + module.getUri() + "]"));
                    continue;
                }
                if (unpackTypesList.contains(module.getType()) && (module.shouldUnpack() == null || module.shouldUnpack().booleanValue()) || module.shouldUnpack() != null && module.shouldUnpack().booleanValue()) {
                    this.getLog().info((CharSequence)("Copying artifact [" + module + "] to [" + module.getUri() + "] (unpacked)"));
                    if (!destinationFile.mkdirs()) {
                        throw new MojoExecutionException("Error creating " + destinationFile);
                    }
                    this.unpack(sourceFile, destinationFile, outdatedResources);
                    if (!this.skinnyWars || !module.changeManifestClasspath()) continue;
                    this.changeManifestClasspath(module, destinationFile, javaEEVersion);
                    continue;
                }
                if (sourceFile.lastModified() > destinationFile.lastModified()) {
                    this.getLog().info((CharSequence)("Copying artifact [" + module + "] to [" + module.getUri() + "]"));
                    FileUtils.copyFile((File)sourceFile, (File)destinationFile);
                    if (this.skinnyWars && module.changeManifestClasspath()) {
                        this.changeManifestClasspath(module, destinationFile, javaEEVersion);
                    }
                } else {
                    this.getLog().debug((CharSequence)("Skipping artifact [" + module + "], as it is already up to date at [" + module.getUri() + "]"));
                }
                outdatedResources.remove(workingDir.relativize(destinationFile.toPath()).toString());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR modules", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking EAR modules", (Exception)((Object)e));
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No Archiver found for EAR modules", (Exception)((Object)e));
        }
    }

    private List<String> createUnpackList() throws MojoExecutionException {
        List<String> unpackTypesList = new ArrayList<String>();
        if (this.unpackTypes != null) {
            unpackTypesList = Arrays.asList(this.unpackTypes.split(","));
            for (String type : unpackTypesList) {
                if (EarModuleFactory.STANDARD_ARTIFACT_TYPE.contains(type)) continue;
                throw new MojoExecutionException("Invalid type [" + type + "] supported types are " + EarModuleFactory.STANDARD_ARTIFACT_TYPE);
            }
            this.getLog().debug((CharSequence)("Initialized unpack types " + unpackTypesList));
        }
        return unpackTypesList;
    }

    public String getApplicationXml() {
        return this.applicationXml;
    }

    public void setApplicationXml(String applicationXml) {
        this.applicationXml = applicationXml;
    }

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>(FileUtils.getDefaultExcludesAsList());
        if (this.earSourceExcludes != null && !"".equals(this.earSourceExcludes)) {
            excludeList.addAll(Arrays.asList(StringUtils.split((String)this.earSourceExcludes, (String)",")));
        }
        if (this.getApplicationXml() != null && !"".equals(this.getApplicationXml())) {
            excludeList.add("**/META-INF/application.xml");
        }
        return excludeList.toArray(new String[excludeList.size()]);
    }

    protected String[] getIncludes() {
        return StringUtils.split((String)Objects.toString(this.earSourceIncludes, ""), (String)",");
    }

    public String[] getPackagingExcludes() {
        if (StringUtils.isEmpty((String)this.packagingExcludes)) {
            return new String[0];
        }
        return StringUtils.split((String)this.packagingExcludes, (String)",");
    }

    public void setPackagingExcludes(String packagingExcludes) {
        this.packagingExcludes = packagingExcludes;
    }

    public String[] getPackagingIncludes() {
        if (StringUtils.isEmpty((String)this.packagingIncludes)) {
            return new String[]{"**"};
        }
        return StringUtils.split((String)this.packagingIncludes, (String)",");
    }

    public void setPackagingIncludes(String packagingIncludes) {
        this.packagingIncludes = packagingIncludes;
    }

    private static File buildDestinationFile(File buildDir, String uri) {
        return new File(buildDir, uri);
    }

    private static File getEarFile(String basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".ear");
    }

    private String[] getEarFiles(File sourceDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public void unpack(File source, final File destDir, final Collection<String> outdatedResources) throws ArchiverException, NoSuchArchiverException, IOException {
        UnArchiver unArchiver = this.archiverManager.getUnArchiver("zip");
        unArchiver.setSourceFile(source);
        unArchiver.setDestDirectory(destDir);
        unArchiver.setFileMappers(new FileMapper[]{new FileMapper(){

            public String getMappedFileName(String pName) {
                Path destFile = destDir.toPath().resolve(pName);
                outdatedResources.remove(EarMojo.this.getWorkDirectory().toPath().relativize(destFile).toString());
                return pName;
            }
        }});
        unArchiver.extract();
    }

    private void copyFile(File source, File target) throws MavenFilteringException, IOException, MojoExecutionException {
        if (this.filtering && !this.isNonFilteredExtension(source.getName())) {
            File parentDirectory = target.getParentFile();
            if (parentDirectory != null && !parentDirectory.exists()) {
                Files.createDirectories(parentDirectory.toPath(), new FileAttribute[0]);
            }
            this.mavenFileFilter.copyFile(source, target, true, this.getFilterWrappers(), this.encoding);
        } else {
            FileUtils.copyFile((File)source, (File)target);
        }
    }

    public boolean isNonFilteredExtension(String fileName) {
        return !this.mavenResourcesFiltering.filteredFileExtension(fileName, this.nonFilteredFileExtensions);
    }

    private List<FileUtils.FilterWrapper> getFilterWrappers() throws MojoExecutionException {
        if (this.filterWrappers == null) {
            try {
                MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
                mavenResourcesExecution.setMavenProject(this.getProject());
                mavenResourcesExecution.setEscapedBackslashesInFilePath(this.escapedBackslashesInFilePath);
                mavenResourcesExecution.setFilters(this.filters);
                mavenResourcesExecution.setEscapeString(this.escapeString);
                this.filterWrappers = this.mavenFileFilter.getDefaultFilterWrappers((AbstractMavenFilteringRequest)mavenResourcesExecution);
            }
            catch (MavenFilteringException e) {
                this.getLog().error((CharSequence)("Fail to build filtering wrappers " + e.getMessage()));
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.filterWrappers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void changeManifestClasspath(EarModule module, File original, JavaEEVersion javaEEVersion) throws MojoFailureException {
        try {
            File manifestFile;
            boolean newManifestCreated;
            File workDirectory;
            if (original.isFile()) {
                workDirectory = new File(new File(this.getTempFolder(), "temp"), module.getUri());
                if (!workDirectory.mkdirs()) throw new MojoFailureException("Failed to create directory " + workDirectory);
                this.getLog().debug((CharSequence)("Created a temporary work directory: " + workDirectory.getAbsolutePath()));
                this.zipUnArchiver.setSourceFile(original);
                this.zipUnArchiver.setDestDirectory(workDirectory);
                this.zipUnArchiver.extract();
            } else {
                workDirectory = original;
            }
            File metaInfDirectory = new File(workDirectory, "META-INF");
            boolean newMetaInfCreated = metaInfDirectory.mkdirs();
            if (newMetaInfCreated) {
                this.getLog().debug((CharSequence)"This project did not have a META-INF directory before, so a new directory was created.");
            }
            if (newManifestCreated = (manifestFile = new File(metaInfDirectory, "MANIFEST.MF")).createNewFile()) {
                this.getLog().debug((CharSequence)"This project did not have a META-INF/MANIFEST.MF file before, so a new file was created.");
            }
            Manifest mf = EarMojo.readManifest(manifestFile);
            Manifest.ExistingAttribute classPath = mf.getMainSection().getAttribute("Class-Path");
            ArrayList<String> classPathElements = new ArrayList<String>();
            if (classPath != null) {
                classPathElements.addAll(Arrays.asList(classPath.getValue().split(" ")));
            } else {
                classPath = new Manifest.Attribute("Class-Path", "");
            }
            for (JarModule jm : this.getAllJarModules()) {
                if (module.getLibDir() == null) continue;
                File artifact = new File(new File(workDirectory, module.getLibDir()), module.getArtifact().getFile().getName());
                if (!artifact.exists()) {
                    this.getLog().debug((CharSequence)"module does not exist with original file name.");
                    artifact = new File(new File(workDirectory, module.getLibDir()), jm.getBundleFileName());
                    this.getLog().debug((CharSequence)("Artifact with mapping:" + artifact.getAbsolutePath()));
                }
                if (!artifact.exists()) {
                    this.getLog().debug((CharSequence)"Artifact with mapping does not exist.");
                    artifact = new File(new File(workDirectory, module.getLibDir()), jm.getArtifact().getFile().getName());
                    this.getLog().debug((CharSequence)("Artifact with orignal file name:" + artifact.getAbsolutePath()));
                }
                if (!artifact.exists()) continue;
                this.getLog().debug((CharSequence)(" -> Artifact to delete: " + artifact));
                if (artifact.delete()) continue;
                this.getLog().error((CharSequence)("Could not delete '" + artifact + "'"));
            }
            for (EarModule o : this.getModules()) {
                if (!(o instanceof JarModule)) continue;
                JarModule jm = (JarModule)o;
                if (classPathElements.contains(jm.getBundleFileName())) {
                    classPathElements.set(classPathElements.indexOf(jm.getBundleFileName()), jm.getUri());
                    continue;
                }
                if (!this.skipClassPathModification) {
                    classPathElements.add(jm.getUri());
                    continue;
                }
                if (!javaEEVersion.lt(JavaEEVersion.FIVE) && this.defaultLibBundleDir != null) continue;
                classPathElements.add(jm.getUri());
            }
            classPath.setValue(StringUtils.join(classPathElements.iterator(), (String)" "));
            mf.getMainSection().addConfiguredAttribute((Manifest.Attribute)classPath);
            try (FileOutputStream out = new FileOutputStream(manifestFile);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
                mf.write((Writer)writer);
            }
            if (!original.isFile()) return;
            if (!original.delete()) {
                this.getLog().error((CharSequence)("Could not delete original artifact file " + original));
            }
            this.getLog().debug((CharSequence)"Zipping module");
            this.zipArchiver.setDestFile(original);
            this.zipArchiver.addDirectory(workDirectory);
            this.zipArchiver.createArchive();
            return;
        }
        catch (IOException | ArchiverException | ManifestException e) {
            throw new MojoFailureException(e.getMessage(), e);
        }
    }

    private static Manifest readManifest(File manifestFile) throws IOException {
        try (FileInputStream in = new FileInputStream(manifestFile);){
            Manifest manifest;
            Manifest manifest2 = manifest = new Manifest((InputStream)in);
            return manifest2;
        }
    }

    private Collection<String> initOutdatedResources() {
        final ArrayList<String> outdatedResources = new ArrayList<String>();
        if (this.getWorkDirectory().exists()) {
            try {
                Files.walkFileTree(this.getWorkDirectory().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        outdatedResources.add(EarMojo.this.getWorkDirectory().toPath().relativize(file).toString());
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Can't detect outdated resources", (Throwable)e);
            }
        }
        return outdatedResources;
    }

    private void deleteOutdatedResources(Collection<String> outdatedResources) {
        long startTime = this.session.getStartTime().getTime();
        for (String outdatedResource : outdatedResources) {
            if (new File(this.getWorkDirectory(), outdatedResource).lastModified() >= startTime) continue;
            this.getLog().info((CharSequence)("deleting outdated resource " + outdatedResource));
            new File(this.getWorkDirectory(), outdatedResource).delete();
        }
    }
}

