/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.codehaus.plexus.util.FileUtils;

public class EclipseCleanMojo
extends AbstractMojo {
    private static final String FILE_DOT_WTPMODULES = ".wtpmodules";
    private static final String FILE_DOT_CLASSPATH = ".classpath";
    private static final String FILE_DOT_PROJECT = ".project";
    private static final String DIR_DOT_SETTINGS = ".settings";
    private String packaging;
    private File basedir;

    public void execute() throws MojoExecutionException {
        if ("pom".equals(this.packaging)) {
            this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.pompackaging"));
            return;
        }
        this.delete(new File(this.basedir, FILE_DOT_PROJECT));
        this.delete(new File(this.basedir, FILE_DOT_CLASSPATH));
        this.delete(new File(this.basedir, FILE_DOT_WTPMODULES));
        this.delete(new File(this.basedir, DIR_DOT_SETTINGS));
    }

    private void delete(File f) throws MojoExecutionException {
        this.getLog().info((CharSequence)Messages.getString("EclipseCleanMojo.deleting", f.getName()));
        if (f.exists()) {
            if (!f.delete()) {
                try {
                    FileUtils.forceDelete((File)f);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(Messages.getString("EclipseCleanMojo.failedtodelete", new Object[]{f.getName(), f.getAbsolutePath()}));
                }
            }
        } else {
            this.getLog().debug((CharSequence)Messages.getString("EclipseCleanMojo.nofilefound", f.getName()));
        }
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }
}

