/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.EclipseUtils;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseResourceWriter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseClasspathWriter
extends AbstractEclipseResourceWriter {
    private static final String M2_REPO = "M2_REPO";
    private File eclipseProjectDir;
    private static final String ATTR_SOURCEPATH = "sourcepath";
    private MavenProject project;
    private static final String ATTR_OUTPUT = "output";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_KIND = "kind";
    private static final String ELT_CLASSPATHENTRY = "classpathentry";
    private static final String ELT_CLASSPATH = "classpath";
    private static final String FILE_DOT_CLASSPATH = ".classpath";
    private Collection artifacts;

    public EclipseClasspathWriter(Log log, File eclipseProjectDir, MavenProject project, Collection artifacts) {
        super(log, eclipseProjectDir, project);
        this.artifacts = artifacts;
    }

    public void write(File projectBaseDir, List referencedReactorArtifacts, EclipseSourceDir[] sourceDirs, List classpathContainers, ArtifactRepository localRepository, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, File buildOutputDirectory) throws MojoExecutionException {
        FileWriter w;
        try {
            w = new FileWriter(new File(this.getEclipseProjectDirectory(), FILE_DOT_CLASSPATH));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        writer.startElement(ELT_CLASSPATH);
        for (int j = 0; j < sourceDirs.length; ++j) {
            EclipseSourceDir dir = sourceDirs[j];
            writer.startElement(ELT_CLASSPATHENTRY);
            writer.addAttribute(ATTR_KIND, "src");
            writer.addAttribute(ATTR_PATH, dir.getPath());
            if (dir.getOutput() != null) {
                writer.addAttribute(ATTR_OUTPUT, dir.getOutput());
            }
            writer.endElement();
        }
        writer.startElement(ELT_CLASSPATHENTRY);
        writer.addAttribute(ATTR_KIND, ATTR_OUTPUT);
        writer.addAttribute(ATTR_PATH, EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, buildOutputDirectory, false));
        writer.endElement();
        Iterator it = classpathContainers.iterator();
        while (it.hasNext()) {
            writer.startElement(ELT_CLASSPATHENTRY);
            writer.addAttribute(ATTR_KIND, "con");
            writer.addAttribute(ATTR_PATH, (String)it.next());
            writer.endElement();
        }
        it = this.artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!artifact.getArtifactHandler().isAddedToClasspath()) continue;
            this.addDependency((XMLWriter)writer, artifact, referencedReactorArtifacts, localRepository, artifactResolver, artifactFactory, projectBaseDir);
        }
        writer.endElement();
        IOUtil.close((Writer)w);
    }

    private void addDependency(XMLWriter writer, Artifact artifact, List referencedReactorArtifacts, ArtifactRepository localRepository, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, File projectBaseDir) throws MojoExecutionException {
        String kind;
        String path;
        String sourcepath = null;
        String javadocpath = null;
        if (referencedReactorArtifacts.contains(artifact)) {
            path = "/" + artifact.getArtifactId();
            kind = "src";
        } else {
            File artifactPath = artifact.getFile();
            if (artifactPath == null) {
                this.getLog().error((CharSequence)Messages.getString("EclipsePlugin.artifactpathisnull", artifact.getId()));
                return;
            }
            if ("system".equals(artifact.getScope())) {
                path = EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, artifactPath, false);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)Messages.getString("EclipsePlugin.artifactissystemscoped", new Object[]{artifact.getArtifactId(), path}));
                }
                kind = "lib";
            } else {
                File localRepositoryFile = new File(localRepository.getBasedir());
                String fullPath = artifactPath.getPath();
                path = "M2_REPO/" + EclipseUtils.toRelativeAndFixSeparator(localRepositoryFile, new File(fullPath), false);
                Artifact sourceArtifact = EclipseUtils.resolveLocalSourceArtifact(artifact, localRepository, artifactResolver, artifactFactory);
                if (sourceArtifact.isResolved()) {
                    sourcepath = "M2_REPO/" + EclipseUtils.toRelativeAndFixSeparator(localRepositoryFile, sourceArtifact.getFile(), false);
                } else {
                    Artifact javadocArtifact = EclipseUtils.resolveLocalJavadocArtifact(artifact, localRepository, artifactResolver, artifactFactory);
                    if (javadocArtifact.isResolved()) {
                        try {
                            javadocpath = StringUtils.replace((String)javadocArtifact.getFile().getCanonicalPath(), (String)"\\", (String)"/");
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException(e.getMessage(), (Exception)e);
                        }
                    }
                }
                kind = "var";
            }
        }
        writer.startElement(ELT_CLASSPATHENTRY);
        writer.addAttribute(ATTR_KIND, kind);
        writer.addAttribute(ATTR_PATH, path);
        if (sourcepath != null) {
            writer.addAttribute(ATTR_SOURCEPATH, sourcepath);
        } else if (javadocpath != null) {
            writer.startElement("attributes");
            writer.startElement("attribute");
            writer.addAttribute("value", "jar:file:/" + javadocpath + "!/");
            writer.addAttribute("name", "javadoc_location");
            writer.endElement();
            writer.endElement();
        }
        writer.endElement();
    }
}

