/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractWtpResourceWriter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseWtpFacetsWriter
extends AbstractWtpResourceWriter {
    private static final String FACET_JST_EAR = "jst.ear";
    private static final String FACET_JST_UTILITY = "jst.utility";
    private static final String FACET_JST_EJB = "jst.ejb";
    private static final String FACET_JST_WEB = "jst.web";
    private static final String FACET_JST_JAVA = "jst.java";
    private static final String ATTR_VERSION = "version";
    private static final String ELT_INSTALLED = "installed";
    private static final String ATTR_FACET = "facet";
    private static final String ELT_FIXED = "fixed";
    private static final String ELT_FACETED_PROJECT = "faceted-project";
    private static final String DIR_WTP_SETTINGS = ".settings";
    private static final String FILE_FACET_CORE_XML = "org.eclipse.wst.common.project.facet.core.xml";

    public EclipseWtpFacetsWriter(Log log, File eclipseProjectDir, MavenProject project, Collection artifacts) {
        super(log, eclipseProjectDir, project, artifacts);
    }

    public void write(List referencedReactorArtifacts, EclipseSourceDir[] sourceDirs, ArtifactRepository localRepository, File buildOutputDirectory) throws MojoExecutionException {
        FileWriter w;
        File settingsDir = new File(this.getEclipseProjectDirectory(), DIR_WTP_SETTINGS);
        settingsDir.mkdirs();
        String packaging = this.getProject().getPackaging();
        try {
            w = new FileWriter(new File(settingsDir, FILE_FACET_CORE_XML));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        this.writeModuleTypeFacetCore((XMLWriter)writer, packaging);
        IOUtil.close((Writer)w);
    }

    private void writeModuleTypeFacetCore(XMLWriter writer, String packaging) {
        writer.startElement(ELT_FACETED_PROJECT);
        writer.startElement(ELT_FIXED);
        writer.addAttribute(ATTR_FACET, FACET_JST_JAVA);
        writer.endElement();
        if ("war".equalsIgnoreCase(packaging)) {
            writer.startElement(ELT_FIXED);
            writer.addAttribute(ATTR_FACET, FACET_JST_WEB);
            writer.endElement();
            writer.startElement(ELT_INSTALLED);
            writer.addAttribute(ATTR_FACET, FACET_JST_WEB);
            writer.addAttribute(ATTR_VERSION, this.resolveServletVersion());
            writer.endElement();
        } else if ("ejb".equalsIgnoreCase(packaging)) {
            writer.startElement(ELT_FIXED);
            writer.addAttribute(ATTR_FACET, FACET_JST_EJB);
            writer.endElement();
            writer.startElement(ELT_INSTALLED);
            writer.addAttribute(ATTR_FACET, FACET_JST_EJB);
            writer.addAttribute(ATTR_VERSION, this.resolveEjbVersion());
            writer.endElement();
        } else if ("ear".equalsIgnoreCase(packaging)) {
            writer.startElement(ELT_FIXED);
            writer.addAttribute(ATTR_FACET, FACET_JST_EAR);
            writer.endElement();
            writer.startElement(ELT_INSTALLED);
            writer.addAttribute(ATTR_FACET, FACET_JST_EAR);
            writer.addAttribute(ATTR_VERSION, this.resolveJ2eeVersion());
            writer.endElement();
        } else if ("jar".equalsIgnoreCase(packaging)) {
            writer.startElement(ELT_FIXED);
            writer.addAttribute(ATTR_FACET, FACET_JST_UTILITY);
            writer.endElement();
            writer.startElement(ELT_INSTALLED);
            writer.addAttribute(ATTR_FACET, FACET_JST_UTILITY);
            writer.addAttribute(ATTR_VERSION, "1.0");
            writer.endElement();
        }
        writer.startElement(ELT_INSTALLED);
        writer.addAttribute(ATTR_FACET, FACET_JST_JAVA);
        writer.addAttribute(ATTR_VERSION, this.resolveJavaVersion());
        writer.endElement();
        writer.endElement();
    }
}

